%define _name findlib
Name: ocaml-%_name
Version: 1.9.1
Release: alt2
Summary: A module packaging tool for OCaml
License: BSD
Group: Development/ML
Url: http://projects.camlcity.org/projects/findlib.html
# https://github.com/ocaml/ocamlfind
Source: %_name-%version.tar
BuildRequires: rpm-build-ocaml >= 1.2 ocaml-labltk-devel >= 8.06.2 libtinfo-devel ocaml-ocamldoc
BuildRequires: ocaml-ocamlbuild libX11-devel tcl-devel tk-devel libncurses-devel openjade

%description
The "findlib" library provides a scheme to manage reusable software
components (packages), and includes tools that support this
scheme. Packages are collections of OCaml modules for which
metainformation can be stored. The packages are kept in the filesystem
hierarchy, but with strict directory structure. The library contains
functions to look the directory up that stores a package, to query
metainformation about a package, and to retrieve dependency
information about multiple packages. There is also a tool that allows
the user to enter queries on the command-line. In order to simplify
compilation and linkage, there are new frontends of the various OCaml
compilers that can directly deal with packages.


%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %_name-%version

sed -i -e 's,@LIBDIR@,%_libdir,g' src/findlib-toolbox/make_wizard.ml
sed -i -e '/path/s,@SITELIB@,\0:%_libdir/ocaml,' findlib.conf.in

%build
(cd tools/extract_args && make)
tools/extract_args/extract_args -o src/findlib/ocaml_args.ml ocamlc ocamlcp ocamlmktop ocamlopt ocamldep ocamldoc ||:
cat src/findlib/ocaml_args.ml
./configure \
    -mandir %_mandir \
    -config %_libdir/ocaml/etc/findlib.conf \
    -no-camlp4 \
    -sitelib `ocamlc -where` \
    #
make all
make opt

%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man{1,5}
make install \
     prefix=$RPM_BUILD_ROOT \
     OCAMLFIND_BIN=%{_bindir} \
     OCAMLFIND_MAN=%{_mandir}

# install dummy META library for seq
mkdir -p %buildroot%_libdir/ocaml/seq

cat >> %buildroot%_libdir/ocaml/seq/META<<'EOF'
name="seq"
version="[distributed with OCaml 4.07 or above]"
description="dummy backward-compatibility package for iterators"
requires=""
EOF


%files
%_bindir/ocamlfind
%_libdir/ocaml/etc/*
%_libdir/ocaml/topfind
%_libdir/ocaml/*
%_man1dir/ocamlfind.1*
%_man5dir/*
%exclude %_libdir/ocaml/findlib/*.a
%exclude %_libdir/ocaml/findlib/*.cmxa
%exclude %_libdir/ocaml/findlib/*.mli
%exclude %_libdir/ocaml/findlib/Makefile.config
%doc LICENSE

%files devel
%doc LICENSE doc/README doc/guide-html
%_libdir/ocaml/findlib/*.a
%_libdir/ocaml/findlib/*.cmxa
%_libdir/ocaml/findlib/*.mli
%_libdir/ocaml/findlib/Makefile.config


%changelog
