Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           opentest4j
Version:        1.2.0
Release:        alt1_5jpp11
Summary:        Open Test Alliance for the JVM
License:        ASL 2.0

URL:            https://github.com/ota4j-team/opentest4j
Source0:        %{url}/archive/r%{version}.tar.gz
Source100:      https://repo1.maven.org/maven2/org/opentest4j/opentest4j/%{version}/opentest4j-%{version}.pom

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(junit:junit)
Source44: import.info

%description
Open Test Alliance for the JVM is a minimal common foundation for
testing libraries on the JVM.  The primary goal of the project is to
enable testing frameworks like JUnit, TestNG, Spock, etc. and
third-party assertion libraries like Hamcrest, AssertJ, etc. to use a
common set of exceptions that IDEs and build tools can support in a
consistent manner across all testing scenarios -- for example, for
consistent handling of failed assertions and failed assumptions as
well as visualization of test execution in IDEs and reports.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%prep
%setup -q -n opentest4j-r%{version}
find -name \*.jar -delete
cp -p %{SOURCE100} pom.xml

%pom_add_dep junit:junit::test

%pom_xpath_inject pom:project "
  <build>
    <pluginManagement>
      <plugins>
        <plugin>
          <artifactId>maven-jar-plugin</artifactId>
          <configuration>
            <archive>
              <manifestEntries>
                <Automatic-Module-Name>org.opentest4j</Automatic-Module-Name>
                <Implementation-Title>opentest4j</Implementation-Title>
                <Implementation-Vendor>opentest4j.org</Implementation-Vendor>
                <Implementation-Version>%{version}</Implementation-Version>
                <Specification-Title>opentest4j</Specification-Title>
                <Specification-Vendor>opentest4j.org</Specification-Vendor>
                <Specification-Version>%{version}</Specification-Version>
                <!-- OSGi metadata required by Eclipse -->
                <Bundle-ManifestVersion>2</Bundle-ManifestVersion>
                <Bundle-SymbolicName>org.opentest4j</Bundle-SymbolicName>
                <Bundle-Version>%{version}</Bundle-Version>
                <Export-Package>org.opentest4j;version=\"%{version}\"</Export-Package>
              </manifestEntries>
            </archive>
          </configuration>
        </plugin>
      </plugins>
    </pluginManagement>
  </build>"

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE
%doc README.md

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE

%changelog
