%def_disable snapshot
%define xdg_name org.kde.partitionmanager

Name: partitionmanager
Version: 22.12.3
Release: alt1

Summary: KDE Partition Manager
License: GPLv3
Group: Graphical desktop/KDE
Url: https://apps.kde.org/%name

%if_disabled snapshot
#Source: https://github.com/KDE/%name/archive/v%version/%name-%version.tar.gz
Source: https://download.kde.org/stable/release-service/%version/src/%name-%version.tar.xz
%else
Vcs: https://github.com/KDE/partitionmanager.git
Source: %name-%version.tar
%endif

%K5init no_altplace appdata

%define qt_ver 5.15.2
%define kpmcore_ver %version

Requires: libkpmcore >= %kpmcore_ver
Requires: qca-qt5-ossl lvm2 cryptsetup polkit

BuildRequires(pre): rpm-build-kf5
BuildRequires: gcc-c++ extra-cmake-modules qt5-base-devel >= %qt_ver
BuildRequires: kf5-kcrash-devel kf5-kdoctools-devel kf5-ki18n-devel
BuildRequires: kf5-kiconthemes-devel kf5-kio-devel kf5-kdbusaddons-devel
BuildRequires: libpolkitqt5-qt5-devel kf5-kdoctools
BuildRequires: libkpmcore-devel >= %kpmcore_ver libatasmart-devel libblkid-devel
BuildRequires: libappstream-glib-devel

%description
KDE Partition Manager is a utility program to help you manage the disk
devices, partitions and file systems on your computer. It allows you to
easily create, copy, move, delete, resize without losing data, backup and
restore partitions. KDE Partition Manager supports a large number of file
systems, including ext2/3/4, reiserfs, NTFS, FAT16/32, jfs, xfs and more.
It makes use of external programs to get its job done, so you might have
to install additional software (preferably packages from your
distribution) to make use of all features and get full support for all
file systems.

%prep
%setup

%build
%K5build

%install
%K5install
%find_lang %name --all-name --with-kde

%files -f %name.lang
%_K5bin/%name
%_K5xdgapp/%xdg_name.desktop
%_K5icon/*/*/apps/%name.*
%_K5cfg/%name.kcfg
%_K5xmlgui/%name/
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/solid/actions/open_in_%name.desktop
%doc README*

%changelog
