%define dist JSON-DWIW

Name: perl-%dist
Version: 0.47
Release: alt5.2

Summary: Flexible and fast JSON converter for Perl
License: GPL or Artistic
Group: Development/Perl

Url: %CPAN %dist
Source: %dist-%version.tar.gz
Patch: perl-JSON-DWIW-0.40-alt-deps.patch

# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: perl-Math-BigInt perl-devel

%description
Other JSON modules require setting several parameters before
calling the conversion methods to do what I want.  This module
does things by default that I think should be done when working
with JSON in Perl.  This module also encodes and decodes faster
than JSON.pm and JSON::Syck in my benchmarks.

This means that any piece of data in Perl (assuming it's valid
unicode) will get converted to something in JSON instead of
throwing an exception.  It also means that output will be strict
JSON, while accepted input will be flexible, without having to
set any options.

%prep
%setup -n %dist-%version
%patch -p1

%build
install -pm755 /usr/share/gnu-config/config.{sub,guess} libjsonevt/
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README WhatsNew
%perl_vendor_archlib/JSON
%perl_vendor_autolib/JSON

%changelog
