%def_enable dafsa

Name: publicsuffix-list
Version: 20250827
Release: alt1
Summary: Cross-vendor public domain suffix database
License: MPL-2.0
Group: Networking/DNS
Url: https://publicsuffix.org/
Vcs: https://github.com/publicsuffix/list.git
Source0: public_suffix_list.dat
Source1: LICENSE
# For libpsl build
Source2: test_psl.txt
BuildArch: noarch

%{?_enable_dafsa:BuildRequires: psl-make-dafsa}

%description
A "public suffix" is one under which Internet users can (or historically could)
directly register names. Some examples of public suffixes are .com, .co.uk and
pvt.k12.ma.us. The Public Suffix List is a list of all known public suffixes.

%package dafsa
Group: Networking/DNS
Summary: Cross-vendor public domain suffix database in DAFSA form

%description dafsa
A "public suffix" is one under which Internet users can (or historically could)
directly register names. Some examples of public suffixes are .com, .co.uk and
pvt.k12.ma.us. The Public Suffix List is a list of all known public suffixes.

This package includes a DAFSA representation of the Public Suffix List
for runtime loading.

%prep
%setup -c -T
cp -a %SOURCE1 COPYING
%if_enabled dafsa
cp -a %SOURCE0 .

%build
LC_CTYPE=C.UTF-8 \
	psl-make-dafsa --output-format=binary \
	  %SOURCE0 public_suffix_list.dafsa
%endif

%install
install -pDm644  %SOURCE0 %buildroot%_datadir/publicsuffix/public_suffix_list.dat
install -pDm644  %SOURCE2 %buildroot%_datadir/publicsuffix/test_psl.txt
ln -s public_suffix_list.dat %buildroot%_datadir/publicsuffix/effective_tld_names.dat
%if_enabled dafsa
install -pDm644 public_suffix_list.dafsa %buildroot%_datadir/publicsuffix/public_suffix_list.dafsa
%endif

%files
%doc COPYING
%dir %_datadir/publicsuffix/
%_datadir/publicsuffix/*
%if_enabled dafsa
%exclude %_datadir/publicsuffix/public_suffix_list.dafsa

%files dafsa
%doc COPYING
%dir %_datadir/publicsuffix/
%_datadir/publicsuffix/public_suffix_list.dafsa
%endif

%changelog
