%define gst_api_ver 1.0
%define xdg_name com.github.wwmm.pulseeffects

Name: pulseeffects
Version: 4.8.5
Release: alt1

Summary: Audio effects for Pulseaudio applications
License: GPL-3.0
Group: Sound
Url: https://github.com/wwmm/pulseeffects

Source: %url/archive/v%version/%name-%version.tar.gz

%define gst_ver 1.12.5
%define glibmm_ver 2.56
%define gtk_ver 3.24
%define calf_ver 0.90.1
%define lsp_ver 1.1.24

Requires: pulseaudio-daemon dconf
Requires: gst-plugins-good%gst_api_ver >= %gst_ver
Requires: gst-plugins-bad%gst_api_ver >= %gst_ver
Requires: ladspa-rubberband
Requires: ladspa-zam-plugins
Requires: calf-plugins >= %calf_ver
%ifarch %ix86 x86_64 aarch64
Requires: lv2-lsp-plugins >= %lsp_ver
%endif

BuildRequires(pre): meson
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel
BuildRequires: gcc-c++ boost-filesystem-devel boost-asio-devel
BuildRequires: libglibmm-devel >= %glibmm_ver libgtkmm3-devel >= %gtk_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel
BuildRequires: libpulseaudio-devel libsndfile-devel libsamplerate-devel libfftw3-devel
BuildRequires: pkgconfig(gstreamer-webrtc-1.0)
BuildRequires: libbs2b-devel
BuildRequires: liblilv-devel
BuildRequires: zita-convolver-devel
BuildRequires: libebur128-devel
BuildRequires: libdbus-devel
#BuildRequires: pkgconfig(rnnoise)

%description
PulseEffects is a limiter, compressor, reverberation, stereo equalizer and auto volume
effects for Pulseaudio applications.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
# system-wide config directory since 4.7.3
mkdir -p %buildroot%_sysconfdir/PulseEffects

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%dir %_sysconfdir/PulseEffects
%_libdir/gstreamer-%gst_api_ver/libgstpeconvolver.so
%_libdir/gstreamer-%gst_api_ver/libgstpecrystalizer.so
%_libdir/gstreamer-%gst_api_ver/libgstpeautogain.so
%_libdir/gstreamer-%gst_api_ver/libgstpeadapter.so
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.*gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* CHANGELOG.*

%changelog
