%define modname Cython
%def_disable debugger

Name: python-module-%modname
Version: 0.29.24
Release: alt1

Summary: C-extensions for Python
Group: Development/Python
License: Apache-2.0
Url: http://www.cython.org

Vcs: https://github.com/cython/cython.git
Source: https://pypi.io/packages/source/C/%modname/%modname-%version.tar.gz
#Source: https://github.com/cython/cython/archive/%version/%modname-%version.tar.gz

Provides: %modname = %EVR
Conflicts: python-module-Cython0.18

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-setuptools python-module-json
%add_python_req_skip IPython

%description
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

%package tests
Summary: Cython test suit
Group: Development/Python
Requires: %name = %EVR
Conflicts: python-module-Cython0.18-tests

%description tests
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python2 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

This package provides modules for testing Cython using unittest.

%package debugger
Summary: Cython debugger
Group: Development/Python
Requires: %name = %EVR
Requires: gdb

%description debugger
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python2 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

This package provides modules for debugging Cython programms.

%prep
%setup -n %modname-%version

%build
%python_build

%install
%python_install
for f in cy{thon{,ize},gdb}; do
mv %buildroot/%_bindir/$f %buildroot/%_bindir/"$f"2;
done

%files
%_bindir/cython2
%_bindir/cythonize2
%python_sitelibdir/pyximport/
%python_sitelibdir/%modname/
%python_sitelibdir/%modname-*egg-info
%python_sitelibdir/cython.py*
%doc *.txt Demos Tools docs

%exclude %python_sitelibdir/%modname/Tests
%exclude %python_sitelibdir/%modname/Debugger

%files tests
%python_sitelibdir/%modname/Tests

%if_enabled debugger
%files debugger
%python_sitelibdir/%modname/Debugger
%_bindir/cygdb2
%endif

%changelog
