%define oname Pygments

Name: python-module-Pygments
Version: 2.4.2
Release: alt3

Summary: Pygments is a syntax highlighting package written in Python

License: BSD
Group: Development/Python
Url: http://pygments.org/

BuildArch: noarch

Source: %name-%version.tar
Source1: autobuild.watch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-docutils
BuildRequires: python-module-objects.inv
BuildRequires: python-module-alabaster
BuildRequires: python-module-html5lib
BuildRequires: time

%description
It is a generic syntax highlighter for general use in all kinds of
software such as forum systems, wikis or other applications that need
to prettify source code. Highlights are:
 * a wide range of common languages and markup formats is supported
 * special attention is paid to details, increasing quality by a fair amount
 * support for new languages and formats are added easily
 * a number of output formats, presently HTML, LaTeX, RTF, SVG and ANSI sequences
 * it is usable as a command-line tool and as a library

%package tests
Summary: Tests for %name
Group: Development/Python
Requires: %name = %version-%release
AutoReq: yes, nopython

%description tests
It is a generic syntax highlighter for general use in all kinds of
software such as forum systems, wikis or other applications that need
to prettify source code. Highlights are:
 * a wide range of common languages and markup formats is supported
 * special attention is paid to details, increasing quality by a fair amount
 * support for new languages and formats are added easily
 * a number of output formats, presently HTML, LaTeX, RTF, SVG and ANSI sequences
 * it is usable as a command-line tool and as a library

This package contains tests for %name.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description doc
It is a generic syntax highlighter for general use in all kinds of
software such as forum systems, wikis or other applications that need
to prettify source code. Highlights are:
 * a wide range of common languages and markup formats is supported
 * special attention is paid to details, increasing quality by a fair amount
 * support for new languages and formats are added easily
 * a number of output formats, presently HTML, LaTeX, RTF, SVG and ANSI sequences
 * it is usable as a command-line tool and as a library

This package contains documentation for %name.

%package pickles
Summary: Pickles for %name
Group: Development/Python
BuildArch: noarch

%description pickles
It is a generic syntax highlighter for general use in all kinds of
software such as forum systems, wikis or other applications that need
to prettify source code. Highlights are:
 * a wide range of common languages and markup formats is supported
 * special attention is paid to details, increasing quality by a fair amount
 * support for new languages and formats are added easily
 * a number of output formats, presently HTML, LaTeX, RTF, SVG and ANSI sequences
 * it is usable as a command-line tool and as a library

This package contains pickles for %name.

%prep
%setup

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build

%make -C doc pickle
%make -C doc html

%install
%python_install

install -d %buildroot%_man1dir
install -d %buildroot%_docdir/%name

install -p -m644 AUTHORS CHANGES LICENSE TODO \
	%buildroot%_docdir/%name/
cp -fR doc/_build/html %buildroot%_docdir/%name/

install -p -m644 doc/pygmentize.1 %buildroot%_man1dir
cp -fR tests %buildroot%python_sitelibdir/pygments/
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/pygments/

%files
%doc %dir %_docdir/%name
%doc %_docdir/%name/*
%exclude %_docdir/%name/html
%_bindir/pygmentize
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/pygments/tests
%_man1dir/*

%files tests
%python_sitelibdir/pygments/tests

%files doc
%doc %dir %_docdir/%name
%doc %_docdir/%name/html

%files pickles
%python_sitelibdir/*/pickle

%changelog
