%define oname nose

%def_without test
%def_with python3

Name: python-module-%oname
Epoch: 1
Version: 1.3.7
Release: alt7.git20160316

Summary: A unittest-based testing framework for python that makes writing and running tests easier

Group: Development/Python
License: LGPL
Url: https://nose.readthedocs.io/en/latest/

BuildArch: noarch

%setup_python_module %oname

Source: %name-%version.tar

# https://github.com/nose-devs/nose/pull/1004
Patch1: %oname-%version-alt-coverage4.patch

# Fix UnicodeDecodeError with captured output
# https://github.com/nose-devs/nose/pull/988
Patch2: python-nose-fedora-unicode.patch

# Allow docutils to read utf-8 source
Patch3: python-nose-fedora-readunicode.patch

# Fix Python 3.6 compatibility
# Python now returns ModuleNotFoundError instead of the previous ImportError
# https://github.com/nose-devs/nose/pull/1029
Patch4: python-nose-fedora-py36.patch

# Fix Python 3.8 compatibility
# Remove a SyntaxWarning (other projects may treat it as error)
Patch5: python-nose-fedora-py38.patch


BuildRequires: python-module-setuptools python-module-coverage
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools
BuildRequires: python3-devel python3-module-coverage
%endif

%description
nose provides an alternate test discovery and running process for
unittest, one that is intended to mimic the behavior of py.test as much
as is reasonably possible without resorting to too much magic.

%if_with python3
%package -n python3-module-%oname
Summary: A unittest-based testing framework for python3 that makes writing and running tests easier
Group: Development/Python3

%description -n python3-module-%oname
nose provides an alternate test discovery and running process for
unittest, one that is intended to mimic the behavior of py.test as much
as is reasonably possible without resorting to too much magic.
%endif

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

sed -i "s|man/man1|share/man/man1|g" setup.py

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

rm -f %buildroot%_bindir/nosetests
ln -s nosetests-%_python_version %buildroot%_bindir/nosetests
ln -s nosetests-%_python_version %buildroot%_bindir/nosetests-2
%if_with python3
ln -s nosetests-%_python3_version %buildroot%_bindir/nosetests3
ln -s nosetests-%_python3_version %buildroot%_bindir/nosetests-3
%endif

%if_with test
%check
python2 ./selftest.py
%if_with python3
pushd ../python3
python3 setup.py build_tests
python3 ./selftest.py
popd
%endif
%endif

%files
%doc AUTHORS CHANGELOG NEWS README.txt examples/
%_bindir/nosetests
%_bindir/nosetests-2
%_bindir/nosetests-%_python_version
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info
%_man1dir/*

%if_with python3
%files -n python3-module-%oname
%_bindir/nosetests3
%_bindir/nosetests-3
%_bindir/nosetests-%_python3_version
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-info
%endif

%changelog
