%define _unpackaged_files_terminate_build 1
%define oname packaging

%def_with docs
%def_without check

Name: python-module-%oname
Version: 19.0
Release: alt3
Summary: Core utilities for Python packages
License: ASLv2.0 or BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/packaging
BuildArch: noarch

# https://github.com/pypa/packaging.git
Source: %name-%version.tar
Patch0: packaging-19.0-Fix-testsuite-for-pytest-5.x.patch

%if_with docs
BuildRequires: python-module-sphinx-devel
%endif

%if_with check
BuildRequires: python2.7(coverage)
BuildRequires: python2.7(pretend)
BuildRequires: python2.7(pyparsing)
BuildRequires: python2.7(pytest)
%endif

%description
Core utilities for Python packages.

%if_with docs
%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
%summary
This package contains documentation for %oname

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Core utilities for Python packages.

This package contains pickles for %oname.
%endif

%prep
%setup
%patch0 -p1

%if_with docs
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%python_build_debug

%install
%python_install

%if_with docs
export PYTHONPATH=$PWD
%make -C docs pickle
%make -C docs html
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python}
tox.py --sitepackages -p auto -o -v

%files
%doc *.rst LICENSE*
%python_sitelibdir/%oname/
%python_sitelibdir/%oname-%version-py%_python_version.egg-info/
%if_with docs
%exclude %python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/* tasks

%files pickles
%python_sitelibdir/*/pickle
%endif

%changelog
