%define oname pygame
%def_with python2
%def_with python3

Name: python-module-%oname
Version: 2.0.1
Release: alt1

Summary: A Python module for interfacing with the SDL multimedia library
Summary(ru_RU.UTF-8): Расширение языка Python для работы с библиотекой SDL

Group: Development/Python
License: LGPL-2.1
Url: http://www.pygame.org

Source: %version.tar.gz
Patch: RPM/SOURCES/pygame-1.9.6-docs.patch

%if_with python2
%setup_python_module pygame
%endif

%define python_includedir %_includedir/python%_python_version
%define python3_includedir %_includedir/python%_python3_version

Provides: python-pygame, %oname
Obsoletes: %oname

Requires: libSDL >= 1.2.7
BuildRequires(pre): rpm-build-python3
#if_with python2
#BuildRequires: python-devel python-modules-compiler
#endif

%add_python_req_skip AppKit Foundation py2app Numeric

# Automatically added by buildreq on Fri Jan 29 2021
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libSDL2-devel libX11-devel libcrypt-devel libfreetype-devel pkg-config python-devel python-module-OpenSSL python-module-Pygments python-module-SQLAlchemy python-module-babel python-module-cffi python-module-chardet python-module-cryptography python-module-cssselect python-module-enum34 python-module-idna python-module-imagesize python-module-ipaddress python-module-jinja2 python-module-lxml python-module-markupsafe python-module-ndg-httpsclient python-module-ntlm python-module-pkg_resources python-module-pycparser python-module-pytz python-module-requests python-module-simplejson python-module-six python-module-sphinx python-module-sphinxcontrib python-module-typing python-module-urllib3 python-module-webencodings python-module-whoosh python-modules python-modules-compiler python-modules-ctypes python-modules-distutils python-modules-email python-modules-encodings python-modules-json python-modules-logging python2-base python3 python3-base python3-dev python3-module-Pygments python3-module-alabaster python3-module-babel python3-module-cffi python3-module-chardet python3-module-cryptography python3-module-docutils python3-module-idna python3-module-imagesize python3-module-jinja2 python3-module-markupsafe python3-module-openssl python3-module-packaging python3-module-pkg_resources python3-module-pytz python3-module-requests python3-module-sphinx python3-module-urllib3 sh4 xorg-proto-devel xz
BuildRequires: ctags libfreetype-devel libSDL2_image-devel libSDL2_mixer-devel libSDL2_ttf-devel libjpeg-devel libpng-devel libportmidi-devel python3-module-setuptools python3-module-sphinxcontrib-applehelp python3-module-sphinxcontrib-devhelp python3-module-sphinxcontrib-htmlhelp python3-module-sphinxcontrib-jsmath python3-module-sphinxcontrib-qthelp python3-module-sphinxcontrib-serializinghtml

%if_with python2
BuildRequires: python-module-alabaster python-module-html5lib python-module-numpy python-module-numpydoc python-module-setuptools python-module-sphinxcontrib-websupport
%endif

%description
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for the Numerical
Python extension. pygame is the successor to the pySDL wrapper project, written
by Mark Baker.

Install %name if you would like to write or play SDL games written in the
python language.

%description -l ru_RU.UTF-8
pygame - расширение языка программирования Python, позволяющее
использовать возможности мультимедийной библиотеки SDL (Simple
DirectMedia Layer), предоставляющей низкоуровневый доступ к звуковым
устройствам, клавиатуре, манипулятору мышь и к буферу экрана на
множестве различных платформ.

%package -n python3-module-%oname
Summary: A Python 3 module for interfacing with the SDL multimedia library
Group: Development/Python3
%add_python3_req_skip AppKit Foundation py2app Numeric opencv

%description -n python3-module-%oname
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for the Numerical
Python extension. pygame is the successor to the pySDL wrapper project, written
by Mark Baker.

Install %name if you would like to write or play SDL games written in the
python language.

%package -n python3-module-%oname-devel
Summary: Pygame development headers (Python 3)
Group: Development/Python3
BuildArch: noarch
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-devel
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for Numerical Python
extension. pygame is the successor to the pySDL wrapper project, written by
Mark Baker.

Install python3-module-%oname-devel if you need the c/c++ include files.

%package -n python3-module-%oname-doc
Summary: Pygame documentation and example programs (Python3 version)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
BuildArch: noarch

%description -n python3-module-%oname-doc
Pygame documentation and example programs (Python3 version)

%package devel
Summary: Pygame development headers
Summary(ru_RU.UTF-8): Файлы для разработчика приложений, использующих pygame
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description devel
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for Numerical Python
extension. pygame is the successor to the pySDL wrapper project, written by
Mark Baker.

Install python3-module-%oname-devel if you need the c/c++ include files.

%description devel -l ru_RU.UTF-8
Пакет содержит заголовочные файлы для разработки pygame.

%package doc
Summary: Pygame documentation and example programs
Group: Development/Python
Requires: %name = %version-%release
BuildArch: noarch

%description doc
pygame is a Python  wrapper  module  for  the  SDL  multimedia  library,
written by Pete Shinners. It contains python functions and classes  that
will allow you to use SDL's support for playing cdroms, audio and  video
output, and keyboard, mouse and joystick  input.  pygame  also  includes
support for Numerical Python extension. pygame is the successor  to  the
pySDL wrapper project, written by Mark Baker.

Install %name-doc  if  you  need  the  API  documentation  and  example
programs.

%prep
%setup -n %oname-%version
%patch -p1

%build
# XXX check:
#export LOCALBASE=%prefix
#add_optflags -fno-strict-aliasing
%if_with python2
%python_build_debug -b build2
%endif
%python3_build_debug -j${NPROCS:-%__nprocs} -b build3
rm -f build && ln -s build3 build
python3 setup.py docs

%install
%if_with python2
rm -f build && ln -s build2 build
%python_install
sed -i '/^pkg_dir =/s@pkg_dir = .*@pkg_dir = "%_defaultdocdir/python-module-pygame-doc-%version"@' %buildroot%python_sitelibdir/%oname/docs/__main__.py
%endif

rm -f build && ln -s build3 build
%python3_install
sed -i '/^pkg_dir =/s@pkg_dir = .*@pkg_dir = "%_defaultdocdir/python3-module-pygame-doc-%version"@' %buildroot%python3_sitelibdir/%oname/docs/__main__.py

%if_with python2
%files
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info

%files doc
%doc _html/.
%endif

%files devel
%python_includedir/%oname/

%files -n python3-module-%oname
%python3_sitelibdir/*

%files -n python3-module-%oname-devel
%python3_includedir/%oname

%files -n python3-module-%oname-doc
%doc _html/.

%changelog
