%define rname pyscard

Name:           python-module-%rname
Version:        1.9.9
Release:        alt1.p10.1
Summary:        A framework for building smart card aware applications in Python

Group:          Development/Python
Packager: 	Andrey Cherepanov <cas@altlinux.org>

# The entire source code is LGPLv2+ except for ClassLoader.py (Python),
# and Synchronization.py, Observer.py (CC-BY-SA 3.0), according to
# http://sourceforge.net/p/pyscard/code/619/

License:        LGPLv2+ and Python and CC-BY-SA
URL:            https://sourceforge.net/projects/pyscard/
Source0:        %rname-%version.tar

BuildRequires(pre): rpm-build-python
BuildRequires:  python-devel
BuildRequires:  python-module-distribute
BuildRequires:  python-module-Pyro4
BuildRequires:  libpcsclite-devel
BuildRequires:  swig >= 1.3.31

Requires:       pcsc-lite
Provides:	pyscard = %version-%release

%description
The pyscard smartcard library is a framework for building smart card
aware applications in Python. The smartcard module is built on top of
the PCSC API Python wrapper module.

%prep
%setup -q -n %rname-%version
# license file is CRLF terminated -- prevent a rpmlint warning
subst 's/\r//' LICENSE
# Adapt to use Pyro4
subst 's/Pyro\./Pyro4./g' smartcard/pyro/PyroReader.py

%build
%python_build

%install
%python_install
chmod 755 %buildroot%python_sitelibdir/smartcard/scard/_scard.so

%files
%doc README.md LICENSE
%doc smartcard/doc/*
%doc smartcard/Examples
%python_sitelibdir/*

%changelog
