%define oname urllib3
%def_disable check

Name: python-module-%oname
Version: 1.25.10
Release: alt3.p10

Epoch: 2

Summary: Library with thread-safe connection pooling, file post support, sanity friendly etc
License: MIT
Group: Development/Python

Url: https://github.com/shazow/urllib3/

# make all imports of things in packages try system copies first
Patch: %name-%version.patch

# https://github.com/shazow/urllib3.git
Source: %oname-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-module-six python-module-backports.ssl_match_hostname
BuildRequires: python-module-ndg-httpsclient
BuildRequires: python-module-sphinx-devel
BuildRequires: python-module-mock
BuildRequires: python-module-nose
BuildRequires: python-module-socks

%setup_python_module %oname

Requires: python-module-ndg-httpsclient
Requires: python-module-six python-module-backports.ssl_match_hostname ca-certificates
%py_requires ndg.httpsclient

%description
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

%package tests
Summary: Tests for urllib3
Group: Development/Python
Requires: %name = %EVR

%description tests
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains tests for urllib3.

%package pickles
Summary: Pickles for urllib3
Group: Development/Python

%description pickles
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains pickles for urllib3.

%package docs
Summary: Documentation for urllib3
Group: Development/Documentation

%description docs
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains documentation for urllib3.

%prep
%setup -n %oname-%version
#rm -rf urllib3/packages/
%patch -p1


%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

%install
%python_install

export PYTHONPATH=%buildroot%python_sitelibdir
pushd docs
%make html
%make pickle
popd

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
py.test

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%changelog
