%define oname Eve-Elastic

%def_disable check

Name: python3-module-%oname
Version: 0.2.5
Release: alt2

Summary: Elasticsearch data layer for eve rest framework
License: GPLv3
Group: Development/Python3
Url: https://pypi.python.org/pypi/Eve-Elastic/
# https://github.com/petrjasek/eve-elastic.git
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%py3_provides eve_elastic

BuildRequires: python3-module-nose python3-module-pytest python3-module-urllib3


%description
Eve-Elastic is elasticsearch data layer for eve REST framework.

Features:

* fulltext search
* filtering via elasticsearch filter dsl
* facets support
* aggragations support
* elasticsearch mapping generator for schema

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build_debug

%install
%python3_install

%check
python3 setup.py test

%files
%doc *.md *.rst
%python3_sitelibdir/*


%changelog
