%define oname cbor2
Name: python3-module-%oname
Version: 5.2.0
Release: alt1

Summary: Pure Python CBOR (de)serializer with extensive tag support

License: MIT
Group: Development/Python
Url: https://github.com/agronholm/cbor2

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

#BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro >= 2.2.4

# for test
BuildRequires: python3-module-setuptools_scm

%description

This library provides encoding and decoding for the Concise Binary Object
Representation (CBOR) (`RFC 7049`_) serialization format. `Read the docs
<https://cbor2.readthedocs.io/>`_ to learn more.

It is implemented in pure python with an optional C backend and is
compatible with versions 2.7 through to 3.7.

On cPython>=3.3 cbor2 can use a built in C module for performance similar
to how ``pickle`` wraps the ``_pickle`` C module in the Python Standard
Library. On Windows, this is restricted to cPython>=3.5.

On PyPy, cbor2 runs with almost identical performance to the C backend.

%prep
%setup

%build
SETUPTOOLS_SCM_DEBUG=1 %python3_build

%install
%python3_install
%python3_prune

%check
%python3_test

%files
%python3_sitelibdir/*

%changelog
