%define oname ccsnmultivar

Name: python3-module-%oname
Version: 0.0.5
Release: alt2

Summary: Multivariate regression analysis of core-collapse simulations
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/ccsnmultivar/
# https://github.com/bwengals/ccsnmultivar.git

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%py3_provides %oname
%py3_requires numpy scipy tabulate sklearn

BuildRequires: python3-module-html5lib python3-module-numpy-testing
BuildRequires: python3-module-pbr python3-module-scikit-learn
BuildRequires: python3-module-tabulate python3-module-unittest2
BuildRequires: python-tools-2to3


%description
This Python module aids the analysis of core-collapse supernova
gravitational waves. It is the companion code for this paper.

* Multivariate Regression of Fourier Transformed or Time Domain
  waveforms
* Hypothesis testing for measuring the influence of physical parameters
* Optionally incorporate additional uncertainty due to detector noise
* Approximate waveforms from anywhere within the parameter space
* Includes the Abdikamalov et. al. catalog for example use

%prep
%setup

## py2 -> py3
find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

sed -i 's|#!/usr/bin/python|#!/usr/bin/python3|' \
    $(find ./ -name '*.py')
##

%build
%python3_build_debug

%install
%python3_install

%check
python3 setup.py test

%files
%doc AUTHORS *.md docs/*.rst Example_Catalogs
%python3_sitelibdir/*


%changelog
