%define _unpackaged_files_terminate_build 1
%define oname daemon

%def_with check

Name: python3-module-%oname
Version: 2.2.4
Release: alt1

Summary: Library to implement a well-behaved Unix daemon process
License: Apache-2.0 / GPLv3
Group: Development/Python3
Url: https://pypi.org/project/python-daemon/

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(docutils)
BuildRequires: python3(twine)
%if_with check
BuildRequires: python3(lockfile)
BuildRequires: python3(mock)
BuildRequires: python3(testscenarios)
BuildRequires: python3(tox)
BuildRequires: python3(coverage)
%endif


%description
A well-behaved Unix daemon process is tricky to get right, but the required
steps are much the same for every daemon program. A DaemonContext instance
holds the behaviour and configured process environment for the program; use the
instance as a context manager to enter a daemon state.

%prep
%setup

%build
%__python3 setup.py egg_info
%python3_build

%install
%python3_install

%check
# skip for now PEP517/PEP518
rm pyproject.toml

# relax requirements
sed -i '/deps = -r{toxinidir}\/pip-requirements\/test\.txt/d' tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}

%_bindir/tox.py3 --sitepackages -p auto -o -v -- -ra

%files
%doc ChangeLog LICENSE.* README doc/*
%python3_sitelibdir/%oname/
%python3_sitelibdir/python_daemon-%version-py%_python3_version.egg-info/


%changelog
