%define oname migrate

Name: python3-module-%oname
Version: 0.13.0
Release: alt1

Summary: Schema migration tools for SQLAlchemy

License: MIT
Group: Development/Python3
Url: https://github.com/openstack/sqlalchemy-migrate

Source: %oname-%version.tar

# Local patch to rename /usr/bin/migrate to sqlalchemy-migrate
Patch1: migrate-sqlalchemy-migrate.patch
Patch2: fix-regex.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pbr

%add_python3_req_skip ibm_db_sa
Provides: python3-module-sqlalchemy-migrate = %EVR

BuildArch: noarch

%description
Schema migration tools for SQLAlchemy designed to support an agile
approach to database design and make it easier to keep development and
production databases in sync as schema changes are required. It allows
you to manage database change sets and database repository versioning.

%package tests
Summary: Tests for Schema migration tools for SQLAlchemy
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Tests for Schema migration tools for SQLAlchemy.

%prep
%setup -n %oname-%version

# suddenly 32bit arches cant process it
sed -i '/pytz/d' test-requirements.txt

%patch1 -p2
%patch2 -p1

%build
export PBR_VERSION=%version
%python3_build

%install
export PBR_VERSION=%version
%python3_install

%check
echo 'sqlite:///__tmp__' > test_db.cfg

%files
%doc README.rst AUTHORS ChangeLog COPYING doc/
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/migrate/tests

%files tests
%python3_sitelibdir/*/tests

%changelog
