%define oname mysqlclient

%def_enable check

Name: python3-module-%oname
Version: 2.0.3
Release: alt1

Summary: Python interface to MySQL
Group: Development/Python3

License: GPL-2.0
Url: https://pypi.python.org/pypi/mysqlclient/
# https://github.com/PyMySQL/mysqlclient-python.git
Source: %name-%version.tar

Conflicts: python3-module-MySQLdb
Conflicts: python3-module-MySQLdb2
Provides: python3-module-MySQLdb
%py3_provides MySQLdb

BuildRequires(pre): rpm-macros-sphinx3 rpm-build-python3
Buildrequires: libmysqlclient21-devel
BuildRequires: python3-module-nose python3-module-pytest time
BuildRequires: python3-module-sphinx

%description
mysqlclient is a fork of MySQL-python. It adds Python 3.3 support and
merges some pull requests.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

BuildArch: noarch

%description docs
This package contains documentation for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
This package contains pickles for %oname.

%prep
%setup
%prepare_sphinx3 .
ln -s ../objects.inv doc/

%build
%python3_build
export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" -C doc html
%make SPHINXBUILD="sphinx-build-3" -C doc pickle
%make SPHINXBUILD="sphinx-build-3" -C doc man

%install
%python3_install
install -d %buildroot%python3_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/
mkdir -p %buildroot%_man1dir/
install -m0644 doc/_build/man/mysqldb.1 %buildroot%_man1dir/

%check
python3 setup.py test

%files
%doc HISTORY* *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/MySQLdb
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/%oname/pickle
%_man1dir/*

%files pickles
%python3_sitelibdir/%oname/pickle

%files docs
%doc doc/_build/html/*

%changelog
