%define _unpackaged_files_terminate_build 1

%define oname nitime

%def_with bootstrap

Name: python3-module-%oname
Version: 0.8.1
Release: alt1
Summary: Nitime: timeseries analysis for neuroscience data
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/nitime/

BuildArch: noarch

# https://github.com/nipy/nitime.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel

%if_with bootstrap
%add_python3_req_skip nitime.six.moves
%endif

%description
Nitime is library of tools and algorithms for the analysis of
time-series data from neuroscience experiments. It contains a
implementation of numerical algorithms for time-series analysis both in
the time and spectral domains, a set of container objects to represent
time-series, and auxiliary objects that expose a high level interface to
the numerical machinery and make common analysis tasks easy to express
with compact and semantically clear code.

%package tests
Summary: Tests for Nitime
Group: Development/Python3
Requires: %name = %EVR

%description tests
Nitime is library of tools and algorithms for the analysis of
time-series data from neuroscience experiments. It contains a
implementation of numerical algorithms for time-series analysis both in
the time and spectral domains, a set of container objects to represent
time-series, and auxiliary objects that expose a high level interface to
the numerical machinery and make common analysis tasks easy to express
with compact and semantically clear code.

This package contains tests for Nitime.

%prep
%setup

## python2 -> python3
sed -i 's|#!/usr/bin/env python$|#!/usr/bin/env python3|' \
    $(find ./ -type f \( -name '*.py' -o -name 'build_release' \
                      -o -name 'ex2rst' -o -name 'release' \))
##

%build
%python3_build_debug

%install
%python3_install

%files
%doc README.txt THANKS
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests


%changelog
