%define oname pyface

Name: python3-module-%oname
Version: 7.3.0
Release: alt1

Summary: Traits-capable windowing framework

License: BSD, EPL and LGPL
Group: Development/Python
URL: https://docs.enthought.com/pyface/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires: python3-module-setuptools

BuildRequires: python3 >= 3.8
# As of Python 3.8, this functionality has been added to the Python standard library.
#py3_use importlib-metadata
#py3_use importlib-resources >= 1.1.0
%py3_use traits >= 6

# TODO: extra requires


# skip wx requirements
%add_python3_req_skip pyface.ui.wx.split_dialog pyface.ui.wx.grid.combobox_focus_handler IPython.frontend.wx.wx_frontend IPython.kernel.core.interpreter
%add_python3_req_skip traitsui.wx traitsui.wx.helper wx.html wx.lib.agw wx.lib.gridmovers wx.lib.layoutf wx.lib.mixins.grid
%add_python3_req_skip wx.lib.scrolledpanel wx.lib.wxpTag wx.py wx.py.pseudo wx.py.shell wx.py.version wx.stc wx.wx wx.xrc

%description
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

%prep
%setup
# Users of Python 3.9 and beyond should use the standard library module
subst 's|importlib_resources|importlib.resources|' pyface/resource/resource_manager.py pyface/tests/test_image_resource.py
sed -i -e 's|"importlib-resources>=1.1.0",||' -e 's|"importlib-metadata",||' pyface/__init__.py
sed -i -e '/importlib-resources/d' -e '/importlib-metadata/d' pyface.egg-info/requires.txt

%build
%python3_build_debug

%install
%python3_install
%python3_prune

# not all tests are removed. remove remaining ones
rm -f \
	%buildroot%python3_sitelibdir/%oname/ui/qt4/util/gui_test_assistant.py \
	%buildroot%python3_sitelibdir/%oname/ui/qt4/util/modal_dialog_tester.py \
	%buildroot%python3_sitelibdir/%oname/ui/qt4/util/testing.py \
	%buildroot%python3_sitelibdir/%oname/util/testing.py \
	|| exit 1

%files
%doc image_LICENSE*.txt LICENSE.txt
%doc README.rst
%python3_sitelibdir/*

%changelog
