%define _unpackaged_files_terminate_build 1
%define oname pygal

%def_with check

Name: python3-module-%oname
Version: 2.4.0
Release: alt2
Summary: A python svg graph plotting library
License: LGPLv3
Group: Development/Python3
Url: https://pypi.org/project/pygal/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/Kozea/pygal.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest-runner

%if_with check
BuildRequires: python3(cairosvg)
BuildRequires: python3(lxml)
BuildRequires: python3(pyquery)
BuildRequires: python3(tox)
%endif

%description
pygal is a dynamic SVG charting library written in python. All the
documentation is on http://pygal.org

%prep
%setup
%autopatch -p1

%build
%python3_build_debug

%install
%python3_install
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i ${i}3
done

# don't package tests
rm -r %buildroot%python3_sitelibdir/%oname/test/

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc CHANGELOG README*
%_bindir/pygal_gen.py3
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info/

%changelog
