%define oname robotframework-elasticsearch

Name: python3-module-%oname
Version: 1.1
Release: alt3

Summary: ElasticSearch library for Robot Framework
License: GPLv2
Group: Development/Python3
Url: https://pypi.python.org/pypi/robotframework-elasticsearch/
BuildArch: noarch

# https://github.com/pagesjaunes/robotframework-elasticsearch.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-robotframework
BuildRequires: python3-module-elasticsearch
BuildRequires: python-tools-2to3

%py3_provides ElasticSearchLib
%py3_requires robotframework elasticsearch


%description
This lib provides basic keywords to interact with elasticsearch in a
RobotFramework testsuite. It allows to query, count, create or delete an
index.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%python3_build_debug

%install
%python3_install

%check
%__python3 setup.py build_ext -i

%files
%doc *.md doc/*
%python3_sitelibdir/*


%changelog
