%define modulename sipsimple

Name: python3-module-%modulename
Version: 5.3.0
Release: alt1

Summary: SIP SIMPLE implementation for Python
License: GPL-3.0+
Group: Development/Python3

Url: https://github.com/AGProjects/python3-sipsimple
Source: python3-%modulename-%version.tar
Source1: deps.tar
Patch: python-module-sipsimple-alt-add-arch-webrtc-defines.patch

Packager: Andrey Cherepanov <cas@altlinux.org>

ExclusiveArch: x86_64 %e2k

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-distribute
BuildRequires: python3-module-Cython
BuildRequires: gcc-c++
BuildRequires: libalsa-devel
BuildRequires: libavformat-devel
BuildRequires: libopus-devel
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libswscale-devel
BuildRequires: libv4l-devel
BuildRequires: libvpx-devel
BuildRequires: libwebrtc-devel
# TODO: Unable to detect /usr/include/silk/SKP_Silk_SDK_API.h
#BuildRequires: libsilk-devel

%description
SIP SIMPLE client SDK is a Software Development Kit for easy development
of SIP end-points that support rich media like Audio, Video, Instant
Messaging, File Transfers, Desktop Sharing and Presence.  Other media
types can be easily added by using an extensible high-level API.

%prep
%setup -n python3-%modulename-%version
tar xf %SOURCE1
%patch -p1
cp -at deps/pjsip/ -- /usr/share/gnu-config/config.*
chmod +x deps/pjsip/*configure
%ifarch %e2k
# more 64-bit little endian arches
sed -i 's,^#elif defined(__aarch64__),& || defined(__e2k__),' \
	deps/pjsip/third_party/webrtc/src/webrtc/typedefs.h
%endif

%build
%python3_build

%install
%python3_install

%files
%doc README
%python3_sitelibdir/%modulename/
%python3_sitelibdir/*.egg-info

%changelog
