%define _unpackaged_files_terminate_build 1
%define oname snappy

%def_without check

Name: python3-module-%oname
Version: 0.5.4
Release: alt2
Summary: Python library for the snappy compression library from Google
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/python-snappy/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libsnappy-devel

%if_with check
BuildRequires: python3(tox)
%endif

%description
Python bindings for the snappy compression library from Google.

%prep
%setup
%patch -p1
grep -qs '#!/usr/bin/env python' snappy/snappy.py || exit 1
sed -i '1{/#!\/usr\/bin\/env python/d}' snappy/snappy.py

%build
%add_optflags -fno-strict-aliasing
%python3_build

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%install
%python3_install

%files
%doc AUTHORS *.rst
%python3_sitelibdir/*

%changelog
