%define _unpackaged_files_terminate_build 1
%define oname theano

%def_without bootstrap

Name:       python3-module-%oname
Version:    1.0.5
Release:    alt2

Summary:    Optimizing compiler for evaluating mathematical expressions on CPUs and GPUs
License:    BSD
Group:      Development/Python3
Url:        https://pypi.org/project/Theano/

BuildArch:  noarch

Source:     %name-%version.tar

Patch1: %oname-alt-numpy-compat.patch
Patch2: %oname-alt-python3-compat.patch

BuildRequires(pre): rpm-build-python3

%add_python3_req_skip lazylinker_ext pycuda scan_perform gnumpy pygpu
%add_python3_req_skip multinomial neighbours theano_object
%add_python3_req_skip lazylinker_ext.lazylinker_ext
%if_with bootstrap
%add_python3_req_skip pycuda.elementwise pycuda.tools pycuda.compiler
%add_python3_req_skip scan_perform.scan_perform theano.compat.six.moves
%add_python3_req_skip pycuda.driver pycuda.gpuarray pygpu.array
%endif


%description
Theano is a Python library that allows you to define, optimize, and efficiently
evaluate mathematical expressions involving multi-dimensional arrays. It is
built on top of NumPy. Theano features:

* **tight integration with NumPy:** a similar interface to NumPy's.
  numpy.ndarrays are also used internally in Theano-compiled functions.
* **transparent use of a GPU:** perform data-intensive computations up
  to 140x faster than on a CPU (support for float32 only).
* **efficient symbolic differentiation:** Theano can compute derivatives
  for functions of one or many inputs.
* **speed and stability optimizations:** avoid nasty bugs when computing
  expressions such as log(1 + exp(x)) for large values of x.
* **dynamic C code generation:** evaluate expressions faster.
* **extensive unit-testing and self-verification:** includes tools for
  detecting and diagnosing bugs and/or potential problems.

%package docs
Summary: Documentation for Theano
Group: Development/Documentation

%description docs
Theano is a Python library that allows you to define, optimize, and efficiently
evaluate mathematical expressions involving multi-dimensional arrays. It is
built on top of NumPy.

This package contains documentation for Theano.

%prep
%setup
%patch1 -p2
%patch2 -p2

%build
export LC_ALL=en_US.UTF-8

sed -i \
	-e 's|#!/usr/bin/env python$|#!/usr/bin/env python3|' \
	-e 's|#! /usr/bin/env python$|#! /usr/bin/env python3|' \
	-e 's|#!/usr/bin/python$|#!/usr/bin/python3|' \
	$(find ./ -name '*.py')

%python3_build_debug

%install
export LC_ALL=en_US.UTF-8

%python3_install

%files
%doc *.txt
%_bindir/theano-*
%python3_sitelibdir/*

%files docs
%doc doc/*

%changelog
