%define oname urllib3
%def_disable check
%def_without docs

Name: python3-module-%oname
Version: 1.26.17
Release: alt0.p10.1

Epoch: 2

Summary: Library with thread-safe connection pooling, file post support, sanity friendly etc
License: MIT
Group: Development/Python3

Url: https://github.com/shazow/urllib3/

# make all imports of things in packages try system copies first
Patch: %name-%version.patch

# https://github.com/shazow/urllib3.git
Source: %oname-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-six
BuildRequires: python3-module-mock
BuildRequires: python3-module-nose
Requires: python3-module-ndg-httpsclient
Requires: python3-module-six ca-certificates
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
%endif

%description
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

%package tests
Summary: Tests for urllib3
Group: Development/Python3
Requires: %name = %EVR

%description tests
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains tests for urllib3.

%if_with docs
%package pickles
Summary: Pickles for urllib3
Group: Development/Python3

%description pickles
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains pickles for urllib3.

%package docs
Summary: Documentation for urllib3
Group: Development/Documentation

%description docs
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains documentation for urllib3.
%endif

%prep
%setup -n %oname-%version
#rm -rf urllib3/packages/
%patch -p1

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build

%install
%python3_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd docs
%make SPHINXBUILD="sphinx-build-3" html
%make SPHINXBUILD="sphinx-build-3" pickle
popd

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
py.test-3

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%if_with docs
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%changelog
