%define _unpackaged_files_terminate_build 1
%define oname zope.i18nmessageid
%define descr \
This package provides facilities for *declaring* messages within \
program source text;  translation of the messages is the responsiblity \
of the 'zope.i18n' package.

%def_with check

Name: python3-module-%oname
Version: 5.0.1
Release: alt2

Summary: Message Identifiers for internationalization
Group: Development/Python3

License: ZPL-2.1
# Source-git https://github.com/zopefoundation/zope.i18nmessageid.git
Url: http://pypi.python.org/pypi/zope.i18nmessageid
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx3 rpm-build-python3
BuildRequires: python3-module-sphinx

%if_with check
BuildRequires: python3-module-zope.testing python3-module-zope.testrunner
%endif

%description
%descr

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
%descr

This package contains documentation for %oname.

%package pickles
Summary: Pickles for Zope Configuration Markup Language (ZCML)
Group: Development/Python3

%description pickles
%descr

This package contains pickles for %oname.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
%descr

This package contains tests for %oname.

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python3_build

%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

%install
%python3_install

install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
# coverage is the extra dep
grep -qs "^[[:space:]]*'coverage',[[:space:]]*$" setup.py || exit 1
sed -i "/^[[:space:]]*'coverage',[[:space:]]*$/d" setup.py

export PYTHONPATH=src
python3 setup.py test -v

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/zope/i18nmessageid/tests.*
%exclude %python3_sitelibdir/*/pickle

%files tests
%python3_sitelibdir/zope/i18nmessageid/tests.*

%files docs
%doc docs/_build/html

%files pickles
%python3_sitelibdir/*/pickle

%changelog
