Name: qpdfview
Version: 0.5
Release: alt2
Summary: Tabbed PDF viewer using the poppler library
License: GPL-2.0-or-later
Group: Office
Url: https://launchpad.net/qpdfview

Source: %name-%version.tar
Patch: qpdfview-0.4.18-fix-build-with-qt5-5.15.patch
Patch1: qpdfview-desktop.patch
# std::optional requires std=c++17 or later. Fixes:
# /usr/include/poppler/qt5/poppler-form.h:888:6: error: ‘optional’ in namespace ‘std’ does not name a template type
Patch2: qpdfview-stdc++17.patch

BuildRequires: qt5-tools
BuildRequires: pkgconfig(poppler-qt5)
BuildRequires: pkgconfig(Qt5DBus)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(ddjvuapi)
BuildRequires: pkgconfig(libspectre)
BuildRequires: pkgconfig(zlib)
BuildRequires: cups-devel
BuildRequires: desktop-file-utils

Requires: qt5-sql-sqlite

%description
qpdfview is a tabbed PDF viewer using the poppler library.

%prep
%setup
%autopatch -p2

%build
lrelease-qt5 qpdfview.pro
%qmake_qt5 qpdfview.pro
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot

install -d %buildroot%_liconsdir
install -d %buildroot%_miconsdir
install -d %buildroot%_niconsdir

ln -s %_iconsdir/hicolor/scalable/apps/%name.svg \
	%buildroot%_liconsdir
ln -s %_iconsdir/hicolor/scalable/apps/%name.svg \
	%buildroot%_miconsdir
ln -s %_iconsdir/hicolor/scalable/apps/%name.svg \
	%buildroot%_niconsdir

%files
%doc CHANGES CONTRIBUTORS README TODO
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/%name
%_liconsdir/*
%_miconsdir/*
%_niconsdir/*
%_libexecdir/%name
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/metainfo/%name.appdata.xml

%changelog
