# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ libX11-devel libXext-devel pkgconfig(aubio) pkgconfig(lv2) pkgconfig(ogg) pkgconfig(samplerate) pkgconfig(xcb) pkgconfig(zlib)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		qtractor
Version:	0.9.22
Release:	alt1_1
Summary:	An Audio/MIDI multi-track sequencer
License:	GPLv2+
Group:		Sound
URL:		http://qtractor.sourceforge.io/
Source0:	http://www.rncbc.org/archive/%{name}-%{version}.tar.gz
Patch0:		qtractor-0.9.6-mga-qmake-strip.patch

BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Widgets)
BuildRequires:	pkgconfig(Qt5Xml)
BuildRequires:	pkgconfig(Qt5X11Extras)
BuildRequires:	pkgconfig(gtk+-2.0)
BuildRequires:	pkgconfig(jack)
BuildRequires:	pkgconfig(sndfile)
BuildRequires:	pkgconfig(mad)
BuildRequires:	pkgconfig(rubberband)
BuildRequires:	pkgconfig(liblo)
BuildRequires:	pkgconfig(lilv-0)
BuildRequires:	pkgconfig(dssi)
BuildRequires:	pkgconfig(suil-0)
BuildRequires:	pkgconfig(alsa)
BuildRequires:	pkgconfig(vorbis)
BuildRequires:	ladspa_sdk
BuildRequires:	qt5-designer qt5-tools

Requires:	dssi dssi-examples
Requires:	ladspa_sdk
Source44: import.info

%description
Qtractor is an Audio/MIDI multi-track sequencer application
written in C++ around the Qt4 or Qt5 toolkit using Qt Designer.

The initial target platform will be Linux, where the Jack Audio
Connection Kit (JACK) for audio, and the Advanced Linux Sound
Architecture (ALSA) for MIDI, are the main infrastructures to
evolve as a fairly-featured Linux Desktop Audio Workstation GUI,
specially dedicated to the personal home-studio.

%prep
%setup -q
%patch0 -p1
# E2K: fixed SSE detection code (ilyakurdyukov@)
%ifarch %e2k
sed -i "/#if defined(__GNUC__)/s|#|#ifdef __e2k__\nreturn true;\n#el|" \
  src/qtractor{AudioEngine,AudioMonitor,InsertPlugin,WsolaTimeStretcher}.cpp
%endif



%build
%configure

%make_build

%install
%makeinstall_std

desktop-file-install \
	--remove-key="X-SuSE-translate" \
	--remove-key="Version" \
	--set-key=Exec --set-value="%{name}" \
	--dir %{buildroot}%{_datadir}/applications \
	%{buildroot}%{_datadir}/applications/%{name}.desktop

%files
%doc AUTHORS ChangeLog README TODO TRANSLATORS
%{_bindir}/%{name}
%{_libdir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/metainfo/%{name}.appdata.xml
%{_iconsdir}/hicolor/32x32/apps/%{name}.png
%{_iconsdir}/hicolor/32x32/mimetypes/*.png
%{_iconsdir}/hicolor/scalable/apps/%{name}.svg
%{_iconsdir}/hicolor/scalable/mimetypes/application-x-%{name}-*.svg
%{_mandir}/man1/%{name}*.1*
%lang(fr) %{_mandir}/fr/man1/%{name}*.1*
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/translations
%lang(cs) %{_datadir}/%{name}/translations/%{name}_cs.qm
%lang(de) %{_datadir}/%{name}/translations/%{name}_de.qm
%lang(es) %{_datadir}/%{name}/translations/%{name}_es.qm
%lang(fr) %{_datadir}/%{name}/translations/%{name}_fr.qm
%lang(it) %{_datadir}/%{name}/translations/%{name}_it.qm
%lang(ja) %{_datadir}/%{name}/translations/%{name}_ja.qm
%lang(pt) %{_datadir}/%{name}/translations/%{name}_pt.qm
%lang(ru) %{_datadir}/%{name}/translations/%{name}_ru.qm


%changelog
