Name: radare2
Version: 5.9.0
Release: alt2

Summary: A reverse engineering framework
License: LGPL-3.0-or-later
Group: Development/Tools
Url: http://radare.org/

Source: %name-%version.tar

BuildRequires: meson
BuildRequires: libcapstone-devel
BuildRequires: liblz4-devel
BuildRequires: libmagic-devel
BuildRequires: libuv-devel
BuildRequires: libxxhash-devel
BuildRequires: libzip-devel
BuildRequires: libssl-devel
BuildRequires: zlib-devel

%package devel
Summary: Development files for %name
License: LGPL-3.0-or-later
Group: Development/Tools

%description
A reverse engineering framework and command line tools.

%description devel
Development files for %name package.

%prep
%setup

%build
%meson \
    -Dr2_gittip=%version-%release      \
    -Duse_sys_magic=true               \
    -Duse_sys_zip=true                 \
    -Duse_sys_zlib=true                \
    -Duse_sys_lz4=true                 \
    -Duse_sys_xxhash=true              \
    -Duse_sys_openssl=true             \
    -Duse_libuv=true                   \
    -Duse_sys_capstone=true
%meson_build -j%([ %__nprocs -gt 32 ] && echo 32 || echo %__nprocs)

%install
%meson_install
# Remove package manager
rm %buildroot%_bindir/r2pm
# Copy r_jemalloc to the include directory
cp -r libr/include/heap %buildroot%_includedir/libr

%files
%doc DEVELOPERS.md COPYING COPYING.LESSER CONTRIBUTING.md README.md
%doc %_docdir/%name
%_bindir/*
%_libdir/libr*.so.*
%_datadir/%name
%_datadir/zsh
%_man1dir/*
%_man7dir/*

%files devel
%_libdir/libr*.so
%_libdir/pkgconfig/*.pc
%_includedir/libr

%changelog
