Name: scanbuttond
Version: 0.2.3
Release: alt4

Summary: Scanner Button tools to SANE

Group: System/Libraries
License: GPL
Url: http://scanbuttond.sf.net

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%name/%name-%version.tar
Source1: scanbuttond.init
Source2: initscanner.sh
Source3: buttonpressed.sh
Source4: scanbuttond.conf
Patch0: scanbuttond-0.2.3.diff

# Automatically added by buildreq on Sat Jan 06 2007
BuildRequires: gcc-c++ libusb-compat-devel

%description
Modern scanners usually have several front panel buttons which are intended to
trigger certain actions like copying, faxing or mailing the scanned document.
This daemon monitors the scanner's buttons and runs a shell script whenever one
of these buttons has been pressed. Because it is accessing the scanner directly
via libusb, there should be no conflicts with SANE or other scanner drivers:
scanbuttond simply won't touch the scanner hardware while you are using SANE.

See http://www.linux.com/print.pl?sid=06/12/18/1937227 for examples.

%prep
%setup -q
%patch0 -p1

%build
%autoreconf
%configure --libdir=%_libdir/%name
%make_build

%install
%makeinstall_std

rm -rf %buildroot%_libdir/%name/*.{la,so}
rm -rf %buildroot%_sysconfdir/scanbuttond/*.sh

mkdir -p -m 755 %buildroot{%_initdir/,%_sysconfdir/sysconfig/}
install -c -m 755 %SOURCE1 %buildroot%_initdir/%name
install -m 755 %SOURCE2 %buildroot%_sysconfdir/%name/
install -m 755 %SOURCE3 %buildroot%_sysconfdir/%name/
install -m 644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/%name

%files
%doc README AUTHORS ChangeLog
%_bindir/%name
%_libdir/%name/
%_initdir/%name
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/meta.conf
%_sysconfdir/%name/*.sh
%config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
