Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           scorchwentbonkers
Version:        1.3
Release:        alt1_16
Summary:        Realtime remake of Scorched Earth
License:        zlib
URL:            http://wasyl.eu/games/scorch-went-bonkers.html
Source0:        http://wasyl.eu/assets/dls/scorch-went-bonkers-src.zip
Source1:        %{name}.desktop
Source2:        %{name}.png
Source3:        %{name}.appdata.xml
Patch0:         %{name}-no-fmod.patch
Patch1:         %{name}-support-16bpp.patch
Patch2:         %{name}-unixify.patch
Patch3:         %{name}-gcc6.patch
Patch4:         %{name}-gcc11.patch
BuildRequires:  gcc-c++
BuildRequires:  liballegro-devel liballegro-devel dumb-devel libAllegroOGG-devel 
BuildRequires:  libGLU-devel desktop-file-utils libappstream-glib
Requires:       icon-theme-hicolor
Source44: import.info

%description
As the name suggests, Scorch Went Bonkers is a remake of the old PC classic.
However, many things were changed and the type of fun delivered by the game is
different. Where Scorched Earth puts emphasis on tactics and careful
calculations, SWB requires quick thinking, perfect timing and only one finger
for controlling your tank. The game is real-time instead of turn based.


%prep
%setup -q -c
%patch0 -p1 -z .no-fmod
%patch1 -p1 -z .16bpp
%patch2 -p1 -z .unix
%patch3 -p1
%patch4 -p1
mv src/menu/Splashscreen.h src/menu/SplashScreen.h


%build
%add_optflags -DALLEGRO_NO_FIX_ALIASES
%make_build PREFIX=%{_prefix} OPTFLAGS="$RPM_OPT_FLAGS -fsigned-char"


%install
make install PREFIX=$RPM_BUILD_ROOT%{_prefix}

# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
install -p -m 644 %{SOURCE2} \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml

%files
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/64x64/apps/%{name}.png


%changelog
