Name: scummvm
Version: 2.8.0
Release: alt1

Summary: Graphic adventure game interpreter
Group: Games/Adventure
License: GPLv2
Url: http://www.scummvm.org

Source: %name-%version.tar.gz
Patch: scummvm-1.3.0-mp2player.patch
Patch1: scummvm-2.2.0-Fluidsynth2.2.patch

Provides: %_gamesdatadir/%name

# Automatically added by buildreq on Sun Dec 31 2023
# optimized out: at-spi2-atk bash5 glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libSDL-devel libX11-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libflac-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libogg-devel libp11-kit libpango-devel libpng-devel libpulseaudio-devel libsasl2-3 libstdc++-devel libvorbis-devel libwayland-client libwayland-cursor libwayland-egl pipewire-jack-libs pipewire-libs pkg-config python3 python3-base python3-dev python3-module-setuptools sh5 xorg-proto-devel zlib-devel
BuildRequires: curl gcc-c++ git-core libSDL_net-devel liba52-devel libalsa-devel libcurl-devel libfaad-devel libfluidsynth-devel libfribidi-devel libgif-devel libgtk+3-devel libjpeg-devel libmad-devel libmikmod-devel libmpeg2-devel libreadline-devel libspeechd-devel libtheora-devel

%description
ScummVM is a collection of interpreters, capable of emulating several
adventure game engines. ScummVM mainly supports games created using
SCUMM (Script Creation Utility for Maniac Mansion), used in various
LucasArts games such as Monkey Island, Day of the Tentacle, and others.

%prep
%setup
%patch -p1
#patch1 -p1

%build
export CXXFLAGS=-DFS_API_VERSION=0x0202
./configure \
	--prefix=%prefix \
	--bindir=%_bindir \
	--mandir=%_mandir \
	--libdir=%_libdir \
	--enable-release \
	--enable-plugins --default-dynamic \
	--disable-nasm --disable-tremor \
	--enable-text-console \
	--enable-all-engines \
	--enable-vkeybd
%make_build

%install
%makeinstall_std

# Menu, themes and extra files
cp -a dists/engine-data %buildroot%_datadir/%name

install -D dists/maemo/scummvm64.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -D dists/maemo/scummvm48.png %buildroot%_iconsdir/hicolor/48x48/apps/%name.png
install -D dists/emscripten/assets/scummvm-192.png buildroot%_iconsdir/hicolor/192x192/apps/%name.png
install -D dists/emscripten/assets/scummvm-512.png buildroot%_iconsdir/hicolor/512x512/apps/%name.png

install -D icons/scummvm.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg

%files
%doc AUTHORS* README* NEWS* TODO* COPYING*
%exclude %_defaultdocdir/%name
%_bindir/scummvm
%_man6dir/scummvm.6*
%_pixmapsdir/*.xpm
%_datadir/applications/*.desktop
%_datadir/metainfo/*
%_iconsdir/hicolor/*/apps/*
%dir %_libdir/%name
%_libdir/%name/*
%dir %_datadir/%name
%_datadir/%name/*

%changelog
