#
# spec file for package sdlpop
#
# Copyright (c) 2020 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

Name: sdlpop
Version: 1.23
Release: alt1

Summary: An open-source port of Prince of Persia
License: GPLv3
Group: Games/Arcade

Url: http://www.popot.org/get_the_games.php?game=SDLPoP
Source: https://github.com/NagyD/SDLPoP/archive/v%version.tar.gz#/SDLPoP-%version.tar.gz

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: pkgconfig
BuildRequires: pkgconfig(SDL2_image)
BuildRequires: pkgconfig(SDL2_mixer)
BuildRequires: pkgconfig(sdl2)
BuildRequires: desktop-file-utils

%description
SDLPoP is an open-source port of Prince of Persia 1,
that runs natively under Linux. It is based on the DOS
version of the game, and uses SDL.

Run the prince executable in a path were the original
game data files are located.

%prep
%setup -n SDLPoP-%version
sed -i 's/\r$//' doc/*.txt

%build
cd src
%cmake
%make_build

%install
install -d %buildroot%_gamesbindir
install -Dm0755 prince %buildroot%_libexecdir/%name/%name
install -Dm0644 data/icon.png \
	%buildroot%_datadir/icons/hicolor/32x32/apps/%name.png
install -d %buildroot%_libexecdir/%name
cp -a data/ %buildroot%_libexecdir/%name

# Install Wrapper
cat > %buildroot%_gamesbindir/%name << EOF
#!/bin/sh
exec "%_libexecdir/%name/\${0##*/}" \$@
EOF

cp -a src/SDLPoP.desktop{.template,}
desktop-file-install \
	--set-icon=%name \
	--remove-key=Path \
	--set-key=Exec --set-value='%_gamesbindir/%name' \
	--dir=%buildroot%_desktopdir src/SDLPoP.desktop

%files
%doc README* doc/ChangeLog.txt
%attr(0755,root,root) %_gamesbindir/sdlpop
%_libexecdir/%name
%_datadir/icons/hicolor/32x32/apps/sdlpop.png
%_datadir/applications/*.desktop

%changelog
