%def_without rtorrentd
%def_without pam

Name: settingsd
Version: 1.0
Release: alt1

Summary: Settingsd - extensible service to control the operating system via D-Bus

Group: System/Servers
License: LGPLv2
URL: https://github.com/Etersoft/settingsd

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-git: https://github.com/Etersoft/settingsd.git
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev

%add_python3_path %_datadir/%name/plugins/

Requires: python3-module-dbus
#, python3-module-pyinotify
# FIXME:
# Requires: chkconfig, service, SysVinit
Requires: pm-utils, lsb-release, hwclock

%description
Extensible service to control the operating system via D-Bus.


%package fmod-disks-smart
Summary: Settingsd functional plugin for view SMART information of disks
Group: Monitoring
Requires: smartmontools
Requires: %name = %EVR
%description fmod-disks-smart
%summary


%package fmod-ntp-config
Summary: Settingsd functional plugin for NTP configuration
Group: System/Configuration/Other
Requires: ntpdate
Requires: %name = %EVR
%description fmod-ntp-config
%summary


%package fmod-dnsmasq-config
Summary: Settingsd functional plugin for dnsmasq configuration
Group: System/Configuration/Networking
Requires: dnsmasq
Requires: %name = %EVR
%description fmod-dnsmasq-config
%summary


%package fmod-rtorrentd-config
Summary: Settingsd functional plugin for rtorrentd configuration
Group: System/Configuration/Networking
Requires: rtorrentd
Requires: %name = %EVR
%description fmod-rtorrentd-config
%summary


%package fmod-nss-roles
Summary: Settingsd functional plugin for NSS roles configuration
Group: System/Libraries
Requires: libnss-role
Requires: %name = %EVR
%description fmod-nss-roles
%summary

%package fmod-pam
Summary: Settingsd functional plugin for PAM authentication
Group: System/Libraries
Requires: %name = %EVR
%description fmod-pam
%summary


%prep
%setup

# due missed gudev
rm -fv configs/settingsd/disks_smart.conf
rm -fv plugins/functions/fmod_disks_smart.py

%build
%python3_build

%install
%python3_install
# FIXME: Hack to drop out buildroot
%__subst 's|%buildroot||g' %buildroot%python3_sitelibdir/%name/const.py


%files
%_bindir/settingsd-server.py
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/main.conf
%config(noreplace) %_sysconfdir/%name/ssl.conf
%_initddir/%name
%_unitdir/%name.service
%_sysconfdir/dbus-1/system.d/*.conf
%dir %_datadir/%name/plugins/*/
%dir %_datadir/%name/data/*/
%_datadir/%name/plugins/functions/__pycache__/
%_datadir/%name/plugins/functions/fmod_common_info.py*
%_datadir/%name/plugins/functions/fmod_date_time.py*
%_datadir/%name/plugins/functions/fmod_example.py*
%_datadir/%name/plugins/functions/fmod_local_users.py*
%_datadir/%name/plugins/functions/fmod_local_groups.py*
%_datadir/%name/plugins/functions/fmod_machine.py*
%_datadir/%name/plugins/functions/fmod_network.py*
%_datadir/%name/plugins/functions/fmod_package_updates.py*
%_datadir/%name/plugins/functions/fmod_settingsd.py*
%_datadir/%name/plugins/functions/fmod_statistics.py*
%_datadir/%name/plugins/functions/fmod_system_services.py*
%_datadir/%name/plugins/functions/fmod_ssl.py*
%python3_sitelibdir/%name/
%python3_sitelibdir/*.egg-info


# due missed python gudev
#files fmod-disks-smart
#config(noreplace) %_sysconfdir/%name/disks_smart.conf
#_datadir/%name/plugins/functions/fmod_disks_smart.py*


%files fmod-ntp-config
%config(noreplace) %_sysconfdir/%name/ntp_config.conf
%_datadir/%name/plugins/functions/fmod_ntp_config.py*


%files fmod-dnsmasq-config
%config(noreplace) %_sysconfdir/%name/dnsmasq_config.conf
%_datadir/%name/plugins/functions/fmod_dnsmasq_config.py*

%if_with rtorrentd
%files fmod-rtorrentd-config
%config(noreplace) %_sysconfdir/%name/rtorrentd_config.conf
%_datadir/%name/plugins/functions/fmod_rtorrentd_config.py*
%endif

%files fmod-nss-roles
%config(noreplace) %_sysconfdir/%name/nss_roles.conf
%_datadir/%name/plugins/functions/fmod_nss_roles.py*

%if_with pam
%files pam
#config(noreplace) %_sysconfdir/%name/pam.conf
%_datadir/%name/plugins/functions/fmod_pam_authentication.py*
%endif

%changelog
