%define _unpackaged_files_terminate_build 1

%define statusdir /var/run/control
%def_enable python
%def_with selinux
%def_with audit

Name: sudo
Version: 1.9.16p2
Release: alt3
Epoch: 1

Summary: Allows command execution as another user
License: ISC
Group: System/Base
Url: https://www.sudo.ws

# ftp://ftp.courtesan.com/pub/sudo/sudo-%version.tar.gz
Source: sudo-%version.tar

Source1: pam.conf
Source2: sudo.control
Source3: sudoers.control
Source4: sudoreplay.control
Source5: sudowheel.control
Source6: sudopw.config
Source7: sudopw.control

Patch: sudo-%version-alt.patch

PreReq: control
Requires: vitmp
Provides: %_sysconfdir/sudoers.d

# Automatically added by buildreq on Wed Apr 09 2003
BuildRequires: flex libpam-devel perl-podlators
# Due check of man pages type
BuildRequires: /usr/bin/nroff

BuildRequires: libcap-devel
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_audit:BuildRequires: libaudit-devel}

BuildRequires: python3-dev

%define _libexecdir %_prefix/libexec/sudo

Summary(ru_RU.UTF-8): Запускает команды в контексте другого пользователя

%description
Sudo is a program designed to allow a sysadmin to give limited root
privileges to users and log root activity.  The basic philosophy is
to give as few privileges as possible but still allow people to get
their work done.

%description -l ru_RU.UTF-8
Sudo - программа, разработанная в помощь системному администратору
делегировать те или иные привилегированные ресурсы пользователям,
с ведением протокола их деятельности.  Основная идея - делегировать
как можно меньше прав, но ровно столько, сколько необходимо для
решения поставленных задач.

%package logsrvd
Summary: High-performance log server for %name
Group: System/Servers
Requires: %name = %epoch:%version-%release

%description logsrvd
%name-logsrvd is a high-performance log server that accepts event and I/O logs from sudo.
It can be used to implement centralized logging of sudo logs.

%package python
Summary: Python plugin for %name
Group: Development/Python
Requires: %name = %epoch:%version-%release

%description python
The %name-python package contains sudo python policy plugin.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %epoch:%version-%release
BuildArch: noarch

%description devel
The %name-devel package contains header files developing sudo
plugins that use %name.

%description devel -l ru_RU.UTF-8
Пакет %name-devel содержит заголовочные файлы для разработки расширений
для програмы %name.

%prep
%setup
%patch -p1

%build
./autogen.sh
export ac_cv_prog_NROFFPROG=nroff
configure_options='
--with-logging=syslog
--with-logfac=authpriv
--enable-shell-sets-home
--enable-log-host
--disable-rpath
--with-pam
--with-ignore-dot
--with-env-editor
--with-tty-tickets
--with-sudoers-mode=0400
--with-editor=/bin/vitmp
--with-sendmail=/usr/sbin/sendmail
--with-sssd
%{subst_with selinux}
%{?_with_audit:--with-linux-audit}
--disable-shared-libutil
--enable-static-sudoers
%{subst_enable python}
--docdir=%_datadir/doc/%name-%version
--with-plugindir=%_libdir/sudo
--libexecdir=%_libdir
--enable-tmpfiles.d=%_tmpfilesdir
--with-secure-path=/sbin:/usr/sbin:/usr/local/sbin:/bin:/usr/bin:/usr/local/bin'

%configure $configure_options --with-passprompt='[sudo] password for %%p:'
%make_build

%install
%makeinstall_std INSTALL_OWNER=
install -pD -m600 %SOURCE1 %buildroot%_sysconfdir/pam.d/sudo
mkdir -p %buildroot%_sysconfdir/sudoers.d
install -pD -m644 %SOURCE6 %buildroot%_sysconfdir/sudoers.d/99-sudopw
chmod u+rwx %buildroot%prefix/*bin/*
install -pD -m755 %SOURCE2 %buildroot%_controldir/sudo
install -pD -m755 %SOURCE3 %buildroot%_controldir/sudoers
install -pD -m755 %SOURCE4 %buildroot%_controldir/sudoreplay
install -pD -m755 %SOURCE5 %buildroot%_controldir/sudowheel
install -pD -m755 %SOURCE7 %buildroot%_controldir/sudopw
bzip2 -9 %buildroot%_datadir/doc/%name-%version/ChangeLog

%find_lang sudo
%find_lang sudoers

cat sudo.lang sudoers.lang > sudo_all.lang
rm sudo.lang sudoers.lang
rm -f %buildroot%_libdir/sudo/*.la %buildroot%_libdir/*.so

mv %buildroot%_sysconfdir/sudoers.dist %buildroot%_datadir/doc/%name-%version/

%pre
%pre_control sudo
%pre_control sudoers
if [ -f "%_controldir/sudoreplay" ]; then
    %pre_control sudoreplay
fi
if [ -f "%_controldir/sudowheel" ]; then
    %pre_control sudowheel
fi
if [ -f "%_controldir/sudopw" ]; then
    %pre_control sudopw
fi

%post
if [ -f %_sysconfdir/sudoers.d/99-sudopw.rpmnew ]; then
    mv -f %_sysconfdir/sudoers.d/99-sudopw.rpmnew %_sysconfdir/sudoers.d_99-sudopw.rpmnew
    echo "warning: created config %_sysconfdir/sudoers.d/99-sudopw.rpmnew"
    echo "         has been moved as %_sysconfdir/sudoers.d_99-sudopw.rpmnew"
fi
%post_control -s wheelonly sudo
%post_control -s strict sudoers
if [ ! -f "%statusdir/sudoreplay" ]; then
    %pre_control sudoreplay
fi
%post_control -s wheelonly sudoreplay
if [ ! -f "%statusdir/sudowheel" ]; then
    %pre_control sudowheel
fi
%post_control -s disabled sudowheel
if [ ! -f "%statusdir/sudopw" ]; then
    %pre_control sudopw
fi
%post_control -s default sudopw

%triggerpostun -- %name < 1:1.8.0
cp -a %_sysconfdir/sudoers %_sysconfdir/sudoers.rpmsave
if ! grep -q '^#includedir %_sysconfdir/sudoers.d$' %_sysconfdir/sudoers; then
    if [ -d %_sysconfdir/sudoers.d ]; then
        echo "WARNING: %_sysconfdir/sudoers.d directory no longer supported indirectly"
        echo "Update %_sysconfdir/sudoers with next line:"
        echo "#includedir %_sysconfdir/sudoers.d"
        echo

        echo >>%_sysconfdir/sudoers
        echo "# Automatically updates by rpm:" >>%_sysconfdir/sudoers
        echo "#includedir %_sysconfdir/sudoers.d" >>%_sysconfdir/sudoers
    fi
fi
if ! grep -q '^#includedir %_sysconfdir/sudo.d$' %_sysconfdir/sudoers; then
    if [ -d %_sysconfdir/sudo.d ]; then
        echo "WARNING: %_sysconfdir/sudo.d compat directory no longer supported indirectly"

        if [ "$(ls -A %_sysconfdir/sudo.d)" ]; then
            echo "Update %_sysconfdir/sudoers with next line:"
            echo "#includedir %_sysconfdir/sudo.d"

            echo >>%_sysconfdir/sudoers
            echo "# Automatically updates by rpm:" >>%_sysconfdir/sudoers
            echo "#includedir %_sysconfdir/sudo.d" >>%_sysconfdir/sudoers
        fi

        echo
    fi
fi

%files -f sudo_all.lang
%config %_controldir/sudo*
%config(noreplace) %_sysconfdir/sudoers.d/99-sudopw
%attr(600,root,root) %config(noreplace) %_sysconfdir/sudo.conf
%attr(400,root,root) %config(noreplace) %_sysconfdir/sudoers
%attr(600,root,root) %config(noreplace) %_sysconfdir/pam.d/sudo
%_tmpfilesdir/%name.conf
%_bindir/sudoedit
%dir %_libdir/sudo
%if_with selinux
%_libdir/sudo/sesh
%endif
%_libdir/sudo/*.so*
%if_enabled python
%exclude %_libdir/sudo/python_plugin.so
%endif
%attr(700,root,root) %_bindir/sudo
%attr(700,root,root) %_bindir/sudoreplay
%attr(755,root,root) %_sbindir/visudo
%attr(700,root,root) %_sysconfdir/sudoers.d
%_bindir/cvtsudoers
%_mandir/man?/*
%exclude %_man5dir/sudo_plugin.5*
%if_enabled python
%exclude %_man5dir/sudo_plugin_python.5*
%endif
%exclude %_man5dir/sudo_logsrv.proto.5*
%exclude %_man5dir/sudo_logsrvd.conf.5*
%exclude %_man8dir/sudo_logsrvd.8*
%exclude %_man8dir/sudo_sendlog.8*
%_datadir/doc/%name-%version/

%files logsrvd
%attr(600,root,root) %config(noreplace) %_sysconfdir/sudo_logsrvd.conf
%_sbindir/sudo_logsrvd
%_sbindir/sudo_sendlog
%_man5dir/sudo_logsrv.proto.5*
%_man5dir/sudo_logsrvd.conf.5*
%_man8dir/sudo_logsrvd.8*
%_man8dir/sudo_sendlog.8*

%if_enabled python
%files python
%_libdir/sudo/python_plugin.so
%_man5dir/sudo_plugin_python.5*
%endif

%files devel
%doc plugins/sample/sample_plugin.c
%_includedir/sudo_plugin.h
%_man5dir/sudo_plugin.5*

%changelog
