%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: sysstat
Version: 12.7.4
Release: alt1
Summary: Performance monitoring tools for Linux
License: GPL-2.0-or-later
Group: Monitoring
URL: http://sebastien.godard.pagesperso-orange.fr/
Vcs: https://github.com/sysstat/sysstat.git
Source: %name-%version.tar
Source1: sysstat.init

BuildRequires: libsensors3-devel
BuildRequires: libsystemd-devel
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc desktop-file-utils}}

%description
The sysstat package contains various utilities, common to many commercial
Unixes, to monitor system performance and usage activity:

- iostat reports CPU statistics and input/output statistics for block devices
  and partitions.
- mpstat reports individual or combined processor related statistics.
- pidstat reports statistics for Linux tasks (processes) : I/O, CPU, memory,
  etc.
- tapestat reports statistics for tape drives connected to the system.
- cifsiostat reports CIFS statistics.

Sysstat also contains tools you can schedule via cron or systemd to collect and
historize performance and activity data:

- sar collects, reports and saves system activity information (see below a list
  of metrics collected by sar).
- sadc is the system activity data collector, used as a backend for sar.
- sa1 collects and stores binary data in the system activity daily data file.
  It is a front end to sadc designed to be run from cron or systemd.
- sa2 writes a summarized daily activity report. It is a front end to sar
  designed to be run from cron or systemd.
- sadf displays data collected by sar in multiple formats (CSV, XML, JSON, etc.)
  and can be used for data exchange with other programs. This command can also
  be used to draw graphs for the various activities collected by sar using SVG
  (Scalable Vector Graphics) format.

%package isag
Summary: Interactive System Activity Graph
License: GPL-2.0-or-later
Group: Monitoring
BuildArch: noarch
Requires: %name = %EVR

%description isag
isag is a command that enables you to plot data stored in a daily data file
by a previous sar run.

%prep
%setup

sed -i '/\[Service\]/a\
LogsDirectory=sa\
PrivateTmp=true\
ProtectClock=true\
ProtectControlGroups=true\
ProtectHome=true\
ProtectHostname=true\
ProtectKernelLogs=true\
ProtectKernelModules=true\
ProtectKernelTunables=true\
ProtectSystem=strict\
RestrictNamespaces=true\
RestrictRealtime=true\
StandardOutput=null\
' sysstat.service.in cron/sysstat-*.service.in

sed -i '/\[Unit\]/a\
After=remote-fs.target local-fs.target' sysstat.service.in

%build
%autoreconf
%add_optflags %(getconf LFS_CFLAGS)
export sa_lib_dir=%_libdir/sa
export SADC_OPT='-S DISK'
%configure \
	--enable-sensors \
	--disable-file-attr \
	--disable-compress-manpg \
	--disable-stripping \
	history=61 \
	compressafter=31 \
	%nil

%make_build

%install
%makeinstall_std IGNORE_MAN_GROUP=y

install -p -m644 -D sysstat.ioconf %buildroot%_sysconfdir/sysconfig/
install -p -m644 -D sysstat.sysconfig %buildroot/etc/sysconfig/sysstat
install ./contrib/isag/isag %buildroot%_bindir
install ./contrib/isag/isag.1  %buildroot%_man1dir
install -Dm044 .gear/isag.desktop %buildroot%_desktopdir/isag.desktop

install -d %buildroot%_sysconfdir/cron.d/
# Create cronjob file inline. We can use here rpm macros for libdir and
# thus allows for multi-arch build.
cat > %buildroot%_sysconfdir/cron.d/%name <<-EOF
	# Run system activity accounting tool every 10 minutes
	# unless system is booted into systemd, in that case
	# sysstat.service will do the work and enable timers.
	*/10 * * * * root  test -d /run/systemd/system || %_libdir/sa/sa1 1 1
	# Generate a daily summary of process accounting.
	0    2 * * * root  test -d /run/systemd/system || %_libdir/sa/sa2 -A
EOF

install -pD -m755 %_sourcedir/sysstat.init %buildroot%_initrddir/sysstat
subst 's!@LIBDIR@!%_libdir!' %buildroot%_initrddir/sysstat

# Install systemd files
mkdir -p %buildroot{%_unitdir,%_presetdir,/lib/systemd/system-sleep}
install -m 0644 sysstat.service %buildroot%_unitdir/
install -m 0644 cron/sysstat-{collect,summary}.{service,timer} %buildroot%_unitdir/
install -m 0644 cron/sysstat.sleep %buildroot/lib/systemd/system-sleep/%name.sleep
echo "enable %name.service" | tee %buildroot%_presetdir/60-%name.preset

# sysstat makefiles install the docs, blow them away
rm -rf %buildroot/usr/doc

%find_lang %name

%check
desktop-file-validate %buildroot%_desktopdir/isag.desktop
%buildroot%_libdir/sa/sadc -S ALL 1 2 a
%buildroot%_bindir/sar -A -f a

%post
SYSTEMCTL=systemctl
%post_service sysstat
# It works w/o enable&start on sysv because of cron.d
# Make it the same on systemd - sysstat.service [mostly]
# enables the timers.
if [ -d /run/systemd/system ]; then
	# User can disable the service and in that case it will not
	# be started.
	$SYSTEMCTL is-enabled --quiet %name &&
	$SYSTEMCTL start %name || :
fi

%preun
%preun_service sysstat
if [[ $1 -eq 0 ]]; then
  # Remove sa logs if removing sysstat completely
  rm -f %_logdir/sa/sa*
fi

%files -f %name.lang
%config(noreplace) %attr(644,root,root) %_sysconfdir/cron.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_sysconfdir/sysconfig/sysstat.ioconf
%_bindir/*
%exclude %_bindir/isag
%_libdir/sa
%_initrddir/%name
%_unitdir/%{name}*
/lib/systemd/system-sleep/%name.sleep
%_presetdir/60-%name.preset
%_man1dir/*
%exclude %_man1dir/isag.*
%_man5dir/*
%_man8dir/*
%attr(750,root,adm) %_logdir/sa
%doc CHANGES CREDITS FAQ.md README.md BUG_REPORT

%files isag
%doc contrib/isag/README-isag
%_bindir/isag
%_man1dir/isag.*
%_desktopdir/isag.desktop

%changelog
