%global optflags_lto %optflags_lto -ffat-lto-objects

%define major 8.6

%add_tcl_req_skip ttk::theme::default

Name: tk
Version: 8.6.13
Release: alt1

Summary: The Tk toolkit fot Tcl scripting language
License: TCL
Group: Development/Tcl
Url: http://www.tcl.tk/

# repacked ftp://ftp.tcl.tk/pub/tcl/tcl8_6/tk%version-src.tar.gz
Source: %name%version-src.tar
Patch1: 0001-ALT-extra-headers.patch
Patch2: 0002-ALT-soname.patch
Patch3: 0003-ALT-norpath.patch
Patch4: 0004-ALT-libpath.patch
Patch5: 0005-ALT-Fedora-configure.in-fix-xft-detection-RH-677692.patch
Patch6: 0006-Fedora-make.patch
Patch7: 0007-ALT-removed-XFT_LIBS-from-the-definition-of-TK_LIBS.patch
Patch8: 0008-ALT-pkgIndex.tcl-location.patch
Patch9: 0009-Fedora-font-sizes-fix.patch

BuildRequires(pre): rpm-build-tcl >= 0.5-alt1
BuildRequires: tcl-devel = %version libXt-devel libXft-devel libXScrnSaver-devel
# tests
BuildRequires: xvfb-run fonts-bitmap-75dpi fonts-bitmap-100dpi fonts-bitmap-misc

Requires: tcl = %version lib%name

Provides: tcl(Ttk)
Provides: tcl(Ttk)-8 = %version
Obsoletes: tcl-tile <= 0.8.2

%package -n lib%name
Summary: The Tk toolkit fot Tcl scripting language - shared library
Group: System/Libraries

%package devel
Summary: Header files and C programming manual for Tk
Group: Development/C
Requires: %name  tcl-devel = %version

%package demos
Summary: A collection of programs to demonstrate the features of the Tk toolkit
Group: Development/Tcl
BuildArch: noarch
Requires: %name

%description
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

%description -n lib%name
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package includes shared tk library only.

%description devel
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package includes header files and C programming manual for Tk.

%description demos
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package contains a collection of programs to demonstrate
the features of the Tk toolkit.

%prep
%setup -q -n %name%version
%autopatch -p2
# remove unneeded stuff
rm -r macosx win

%build
pushd unix
%autoreconf
%configure \
	--disable-rpath \
	--enable-threads \
	--enable-xft \
	#
%make_build
popd

%install
%define docdir %_defaultdocdir/%name-%version
%make_install INSTALL_ROOT=%buildroot install -C unix
ln -sf wish%major %buildroot%_bindir/wish
ln -sf lib%name%major.so %buildroot%_libdir/lib%name.so
ln -s ../unix/tkUnixPort.h %buildroot%_includedir/tk/generic/tkUnixPort.h

mkdir -p %buildroot%docdir
xz changes ChangeLog
install -pm0644 README.md license.terms changes.xz ChangeLog.xz %buildroot%docdir

%check
cleanup_check()
{
        for p in $(jobs -p); do
                kill "$p"
        done

        exit "$@"
}

trap 'cleanup_check $?' EXIT

LD_LIBRARY_PATH=%buildroot%_libdir; export LD_LIBRARY_PATH
TCL_LIBRARY="%buildroot%_tcldatadir/tcl%major %buildroot%_tcldatadir/%name%major"; export TCL_LIBRARY

Xvfb :0 &
export DISPLAY=:0
pushd unix
make test
popd

%files
%dir %docdir
%docdir/README.md
%docdir/license.terms
%docdir/changes.*

%dir %_tcllibdir/tk%major
%_bindir/wish*
%dir %_tcldatadir/%name%major
%_tcldatadir/%name%major/*
%_tcllibdir/%name%major/pkgIndex.tcl
%exclude %_tcldatadir/%name%major/demos
%exclude %_tcldatadir/%name%major/%{name}AppInit.c
%_man1dir/*
%_mandir/mann/*

%files -n lib%name
%_libdir/lib%name%major.so

%files devel
%docdir/ChangeLog.*
%_includedir/*
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so
%_libdir/lib%{name}stub%{major}.a
%_libdir/%{name}Config.sh
%_tcldatadir/%name%major/%{name}AppInit.c
%_man3dir/*

%files demos
%_tcldatadir/%name%major/demos

%changelog
