%def_disable snapshot
%define _name tracker
%define ver_major 3.1
%define beta %nil
%define api_ver_major 3
%define api_ver %{api_ver_major}.0
%define gst_api_ver 1.0
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

# since 1.0.3 (see https://bugzilla.gnome.org/show_bug.cgi?id=733857)
%set_verify_elf_method unresolved=relaxed

%def_with bootstrap
%def_enable introspection
%def_enable upower
%def_enable stemmer
%def_enable docs
%def_enable man
%def_enable test_utils

# Unicode support library? (unistring|icu)
%define unicode_support icu

%define _libexecdir %_prefix/libexec

Name: %_name%api_ver_major
Version: %ver_major.2
Release: alt1%beta

Summary: Tracker is a powerfull desktop-oriented search tool and indexer
License: GPL-2.0 and LGPL-2.1-or-later
Group: Office
Url: http://wiki.gnome.org/Projects/Tracker

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz
%else
Source: %_name-%version.tar
%endif

Requires: lib%name = %EVR
Requires: dconf
%{?_without_bootstrap:Requires:  %_name-miners%api_ver_major >= %ver_major}

%define dbus_ver 1.3.1
%define glib_ver 2.44.0
%define pango_ver 1.0.0
%define gtk_ver 3.0.0
%define upower_ver 0.9.0
%define gst_ver 1.0
%define sqlite_ver 3.20.1-alt2
%define soup_ver 2.40.0
%define gupnp_dlna_ver 0.9.4

Requires: libsqlite3 >= %sqlite_ver

BuildRequires(pre): meson rpm-build-gnome rpm-build-gir
%{?_enable_test_utils:
BuildRequires(pre): rpm-build-python3
%add_python3_path %_libdir/%_name-%api_ver/trackertestutils
}
BuildRequires: /proc gcc-c++ gnome-common
BuildRequires: gtk-doc docbook-utils python3
BuildRequires: libxml2-devel libicu-devel libuuid-devel
BuildRequires: libdbus-devel >= %dbus_ver
BuildRequires: libgio-devel >= %glib_ver libpango-devel >= %pango_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libsoup-devel >= %soup_ver libjson-glib-devel
BuildRequires: gobject-introspection-devel
%{?_enable_upower:BuildRequires: libupower-devel >= %upower_ver}
%{?_enable_stemmer:BuildRequires: libstemmer-devel}
%{?_enable_man:BuildRequires: asciidoc-a2x xsltproc}
BuildRequires: vala-tools
BuildRequires: sqlite3 libsqlite3-devel >= %sqlite_ver
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: libgupnp-dlna-devel >= %gupnp_dlna_ver
BuildRequires: pkgconfig(systemd) libseccomp-devel
BuildRequires: bash-completion

%description
Tracker is a powerful desktop-neutral first class object
database, tag/metadata database, search tool and indexer.

%package devel
Summary: Headers for developing programs that will use %name-miner
Group: Development/Other
Requires: lib%name = %EVR
Requires: %name = %EVR
Obsoletes: lib%name-client-devel
License: LGPL-2.1

%description devel
Tracker is a powerfull desktop-oriented search tool and indexer.
This package contains header files for development  and link applications with libtracker-miner.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for %name.

%package -n lib%name
Summary: Tracker shared libraries
Group: System/Libraries
Conflicts: %name < %version-%release

%description -n lib%name
This package contains shred Tracker libraries for applications.

%package -n lib%name-gir
Summary: GObject introspection data for the Tracker library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Tracker library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Tracker library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Provides: gir(Tracker) = %api_ver

%description -n lib%name-gir-devel
GObject introspection devel data for the Tracker library

%package tests
Summary: Tests for Tracker search tool
Group: Development/Other
Requires: %name = %EVR
Provides: tracker-sandbox %name-sandbox

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Tracker.

%prep
%setup -n %_name-%version%beta
#fixed install_rpath for tracker, tracker-store binaries
sed -i 's/tracker_install_rpath/tracker_internal_libs_dir/' src/*/meson.build

%build
%meson \
	-Dunicode_support=%unicode_support \
	%{?_enable_stemmer:-Dstemmer=enabled} \
	%{?_disable_docs:-Ddocs=false} \
	%{?_disable_man:-Dman=false} \
	%{?_disable_test_utils:-Dtest_utils=false} \
	-Dtest_utils_dir='%_libdir/%_name-%api_ver'
%nil
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%dir %_libdir/%_name-%api_ver
%_libexecdir/*
%dir %_datadir/%name
%_datadir/%name/stop-words/
%_datadir/%name/ontologies/
%_datadir/bash-completion/completions/%name
%_userunitdir/%_name-xdg-portal-%api_ver_major.service
%_datadir/dbus-1/services/org.freedesktop.portal.Tracker.service
%if_enabled man
%_man1dir/%_name-xdg-portal*
%_man1dir/%name-endpoint.*
%_man1dir/%name-export.*
%_man1dir/%name-import.*
%_man1dir/%name-sparql.*
%_man1dir/%name-sql.*
%endif
%doc AUTHORS NEWS README*

%files -n lib%name
%_libdir/*.so.*
#%_libdir/%_name-%api_ver/*.so

%files devel
%_includedir/%_name-%api_ver/
%_pkgconfigdir/*.pc
%_libdir/*.so
%_vapidir/*

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Tracker-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Tracker-%api_ver.gir
%endif

%if_enabled test_utils
%files tests
%_libdir/%_name-%api_ver/trackertestutils/
%endif

%changelog
