Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           truth
Version:        0.28
Release:        alt2_0jpp8
Summary:        An assertion framework for Java unit tests
License:        ASL 2.0
URL:            https://github.com/google/truth
Source0:        %name-%version.tar.xz
Patch0:		sameInstance.patch
Patch1:		hasMessageThat.patch
Patch2:		actual.patch
Patch3:		hasCauseThat.patch
BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(com.google.auto.value:auto-value)
BuildRequires:  mvn(com.google.code.findbugs:jsr305)
BuildRequires:  mvn(com.google.guava:guava)
BuildRequires:  mvn(com.google.guava:guava-testlib)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.maven.plugins:maven-source-plugin)
BuildRequires:  mvn(org.sonatype.oss:oss-parent:pom:)

%description
Truth is a library provides alternative ways to express assertions in
unit tests. It can be used as a replacement for JUnit's assertions or FEST
or it can be used alongside where other approaches seem more suitable.

%package        javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q

%autopatch -p2

%pom_disable_module re2j extensions
%pom_remove_plugin :gwt-maven-plugin core
%pom_remove_dep :gwt-user core
%pom_remove_dep :guava-gwt core
%pom_remove_dep -r :compile-testing
%pom_xpath_inject "pom:build/pom:plugins/pom:plugin[pom:artifactId[text()='maven-compiler-plugin']]/pom:configuration" "
          <testExcludes>
            <exclude>**/gwt/*.java</exclude>
	    <exclude>**/ComparableSubjectTest.java</exclude>
          </testExcludes>" core

# Switch to Java 8:
sed -i -e '/<\(source\|target\)/ s/1\.6/1.8/' core/pom.xml

# Adapt to Guava v25 Range toString():
sed -i -e 's/‥/../g' `grep -rl '‥' core/src/test/java`

%build
%mvn_build -j

%install
%mvn_install

%files -f .mfiles
%doc README.md
%dir %{_javadir}/%{name}
%doc LICENSE

#%files javadoc -f .mfiles-javadoc
#%doc LICENSE

%changelog
