Name: waypipe
Version: 0.8.0
Release: alt1

Summary: Network transparency agent for Wayland

Group: Networking/Remote access
License: X11
URL: https://gitlab.freedesktop.org/mstoeckl/waypipe/

Source: %name-%version-%release.tar
# VCS: git://gitlab.freedesktop.org/mstoeckl/waypipe.git
#Patch: %name-%version-%release.patch

# 'man-pages' is always enabled.
# We can't embed a hyphen in a rpm macro name, and anyway
# one short man doesn't weigh much.
%def_with with_video
%def_with with_dmabuf
%def_with with_lz4
%def_with with_zstd
%def_with with_vaapi
%def_disable with_systemtap
%def_enable with_avx512f
%def_enable with_avx2
%def_enable with_sse3
%def_enable with_neon_opts

%define meson_subst_bool() %{expand:%%{?_enable_%{1}:-D%{1}=true}%%{?_disable_%{1}:-D%{1}=false}}
%define meson_subst_feature() %{expand:%%{?_with_%{1}:-D%{1}=enabled}%%{?_without_%{1}:-D%{1}=disabled}}

BuildRequires: meson >= 0.47.0
BuildRequires: gcc
%{?_with_with_video:BuildRequires: pkgconfig(libavcodec)}
%{?_with_with_video:BuildRequires: pkgconfig(libswscale)}
%{?_with_with_dmabuf:BuildRequires: libgbm-devel}
%{?_with_with_dmabuf:BuildRequires: pkgconfig(libdrm)}
%{?_with_with_lz4:BuildRequires: pkgconfig(liblz4)}
%{?_with_with_zstd:BuildRequires: pkgconfig(libzstd) >= 1.4.0}
%{?_with_with_vaapi:BuildRequires: pkgconfig(libva)}
BuildRequires: wayland-protocols >= 1.12
BuildRequires: libwayland-server-devel libwayland-client-devel
BuildRequires: scdoc

%define _unpackaged_files_terminate_build 1

%description
waypipe is a tool which can be used to relay both messages and data between any
Wayland client and compositor over a single transport channel. This should
enable Wayland-based workflows similar to those using `ssh -X'.

%prep
%setup -n %name-%version-%release
#patch -p1

%build
export CFLAGS="%optflags -Wno-error=unused-result"
%meson \
    -D'man-pages=enabled'                \
    %{meson_subst_feature with_video}    \
    %{meson_subst_feature with_dmabuf}   \
    %{meson_subst_feature with_lz4}      \
    %{meson_subst_feature with_zstd}     \
    %{meson_subst_feature with_vaapi}    \
    %{meson_subst_bool with_systemtap}   \
    #
%meson_build

%check
#export LC_ALL=en_US.UTF-8
export LC_CTYPE=en_US.UTF-8

%install
%meson_install

%files
%doc README.md COPYING
%_bindir/waypipe
%_man1dir/waypipe.1*

%changelog
