Name: wine-cpcsp_proxy
Version: 0.6.1
Release: alt1

Summary: Proxy for using Linux CryptoPro in Windows applications with wine

License: LGPLv2
Group: Emulators
URL: https://github.com/Etersoft/wine-cpcsp_proxy

Source: %name-%version.tar

ExclusiveArch: %ix86 x86_64

BuildRequires: libwine-devel >= 6.23
# for wineapploader
#BuildRequires: wine-common

# TODO: move to rpm-macros-wine
# set arch dependent dirs
%ifarch %{ix86}
%define winepedir i386-windows
%define winesodir i386-unix
%endif
%ifarch x86_64
%define winepedir x86_64-windows
%define winesodir x86_64-unix
%endif

#Conflicts: wine-p11csp

%define winelibdir %_libdir/wine

%add_verify_elf_skiplist %winelibdir/%winesodir/cpcsp_proxy.dll.so
%add_verify_elf_skiplist %winelibdir/%winesodir/cpcsp_proxy_setup.exe.so

%ifarch x86_64
%define capilitepkg lsb-cprocsp-capilite-64
%else
%define capilitepkg lsb-cprocsp-capilite
%endif

%description
Proxy for using Linux CryptoPro in Windows applications with wine.

* Use with CryptoPro:
 install %capilitepkg package
* Use with cprocsp_compat (CRYPTO@Etersoft):
 install cprocsp_compat

%prep
%setup

%build
%make_build -C cpcsp_proxy
%make_build -C cpcsp_proxy_setup

%install
mkdir -p %buildroot%winelibdir/{%winesodir,%winepedir}

cp cpcsp_proxy/cpcsp_proxy.dll.so %buildroot%winelibdir/%winesodir
cp cpcsp_proxy/cpcsp_proxy.dll %buildroot%winelibdir/%winepedir
cp cpcsp_proxy_setup/cpcsp_proxy_setup.exe.so %buildroot%winelibdir/%winesodir
cp cpcsp_proxy_setup/cpcsp_proxy_setup.exe %buildroot%winelibdir/%winepedir

mkdir -p %buildroot/%_bindir/
cp %_bindir/wineapploader %buildroot/%_bindir/cpcsp_proxy_setup

%files
%winelibdir/%winesodir/cpcsp_proxy_setup.exe.so
%winelibdir/%winesodir/cpcsp_proxy.dll.so
%winelibdir/%winepedir/cpcsp_proxy_setup.exe
%winelibdir/%winepedir/cpcsp_proxy.dll
%_bindir/cpcsp_proxy_setup

%changelog
