%def_without java
%ifarch riscv64
%def_without qt
%def_without qt5
%else
%def_with qt
%def_with qt5
%endif

Name: zbar
Version: 0.23.92
Release: alt1
%define libname libzbar

Summary: A library for scanning and decoding bar codes

Group: Graphics
License: GPLv2+
Url: https://github.com/mchehab/zbar
Source: %name-%version.tar

BuildRequires: glibc-devel-static libImageMagick-devel libdbus-devel libgtk+3-devel libjpeg-devel libv4l-devel python3-dev xmlto

%if_with qt5
BuildRequires: qt5-x11extras-devel
%endif

%description
Zbar is the utils and library for scanning and decoding bar codes from
various sources such as video streams, image files or raw intensity
sensors. It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5.
Included with the library are basic applications for decoding
captured bar code images and using a video device (eg, webcam) as a
bar code scanner. The flexible, layered architecture features a fast,
streaming interface with a minimal memory footprint.

%package -n %libname
Group: Development/C++
Summary: Bar code library files

%description -n %libname
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of
5. Included with the library are basic applications for decoding
captured bar code images and using a video device (eg, webcam) as a
bar code scanner.

%package -n %libname-devel
Group: Development/C++
Summary: Bar code library extra development files

%description -n %libname-devel
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains header files and additional libraries used for
developing applications that read bar codes with this library.

%package -n %libname-devel-static
Group: Development/C++
Summary: Bar code library extra development files and static libraries

%description -n %libname-devel-static
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains additional static libraries used for
developing applications that read bar codes with this library.

%package -n %libname-gtk3
Group: Development/GNOME and GTK+
Summary: Bar code reader GTK3 widget

%description -n %libname-gtk3
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains a bar code scanning widget for use with GUI
applications based on GTK+-2.0.

%package -n %libname-gtk3-devel
Group: Development/GNOME and GTK+
Summary: Bar code reader GTK widget extra development files

%description -n %libname-gtk3-devel
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains header files and additional libraries used for
developing GUI applications based on GTK+-3.0 that include a bar code
scanning widget.

%package -n %libname-gtk3-devel-static
Group: Development/GNOME and GTK+
Summary: Bar code reader GTK3 widget extra development files and static libraries

%description -n %libname-gtk3-devel-static
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains header files and additional static libraries used for
developing GUI applications based on GTK+-3.0 that include a bar code
scanning widget.

%package -n python3-module-%name
Group: Development/Python3
Summary: Bar code reader PyGTK3 widget

%description -n python3-module-zbar
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains a bar code scanning widget for use in GUI
applications based on PyGTK.

%package gtk
Group: Graphics
Summary: Bar code camera reader GTK3 aplication

%description gtk
%summary

%if_with qt5
%package qt5
Group: Graphics
Summary: Bar code camera reader Qt5 aplication

%description qt5
%summary

%package -n %libname-qt5
Group: Development/KDE and QT
Summary: Bar code reader Qt5 widget

%description -n %libname-qt5
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains a bar code scanning widget for use with GUI
applications based on Qt5.

%package -n %libname-qt5-devel
Group: Development/KDE and QT
Summary: Bar code reader Qt widget extra development files

%description -n %libname-qt5-devel
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains header files and additional libraries used for
developing GUI applications based on Qt5 that include a bar code
scanning widget.

%package -n %libname-qt5-devel-static
Group: Development/KDE and QT
Summary: Bar code reader Qt5 widget extra development files and static libraries

%description -n %libname-qt5-devel-static
Zbar is a library for scanning and decoding bar codes from various
sources such as video streams, image files or raw intensity sensors.
It supports EAN, UPC, Code 128, Code 39 and Interleaved 2 of 5. The
flexible, layered architecture features a fast, streaming interface
with a minimal memory footprint.

This package contains header files and additional static libraries used for
developing GUI applications based on Qt5 that include a bar code
scanning widget.
%endif

%prep
%setup
# TODO
sed -i 's/gtk+-2.0/gtk+-3.0/' zbar-gtk.pc.in

%build
%autoreconf
export LIBS=-lm
%configure \
	%{subst_with qt} \
	%{subst_with qt5} \
	%{subst_with java} \
	--with-python=python3 \
	--with-gtk=gtk3 \
	--with-gir=yes \

%make_build

%install
%make_install DESTDIR=%buildroot install

%files
%_bindir/zbarimg
%_bindir/zbarcam
%_man1dir/*

%files -n %libname
%_libdir/%libname.so.*
%doc %_docdir/%name/[^H]*.md

%files -n %libname-devel
%doc %_docdir/%name/HACKING*
%_libdir/%libname.so
%_pkgconfigdir/%name.pc
%_includedir/%name.h
%_includedir/%name/*.h
%exclude %_includedir/%name/*gtk.h
%exclude %_includedir/%name/Q*

%files -n %libname-devel-static
%_libdir/%libname.a

%files -n %libname-gtk3
%_libdir/libzbargtk.so.*

%files -n %libname-gtk3-devel
%_libdir/libzbargtk.so
%_pkgconfigdir/zbar-gtk.pc
%_includedir/%name/*gtk.h

%files -n %libname-gtk3-devel-static
%_libdir/libzbargtk.a

%files -n python3-module-%name
%python3_sitelibdir/*.so

%files gtk
%_bindir/*gtk

%if_with qt5
%files qt5
%_bindir/*qt

%files -n %libname-qt5
%_libdir/libzbarqt.so.*

%files -n %libname-qt5-devel
%_libdir/libzbarqt.so
%_pkgconfigdir/zbar-qt.pc
%_includedir/%name/Q*.h

%files -n %libname-qt5-devel-static
%_libdir/libzbarqt.a
%endif

%changelog
