# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: CuraEngine
Epoch: 1
Version: 4.11.0
Release: alt1

Summary: Engine for processing 3D models into G-code instructions for 3D printers
License: AGPL-3.0
Group: Engineering
Url: https://github.com/Ultimaker/CuraEngine

Packager: Anton Midyukov <antohami@altlinux.org>

Source: %name-%version.tar
# Source-url: https://github.com/Ultimaker/%name/archive/refs/tags/%version.tar.gz

Patch1: %name-rpath.patch
Patch2: %name-static-libstdcpp.patch

# A weird part of cmake stuff that does not work at all, not present in upstream master
Patch3: fix-stb-PATH.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: protobuf-compiler
BuildRequires: pkgconfig(protobuf)
BuildRequires: libpolyclipping-devel
BuildRequires: pkgconfig(RapidJSON)
BuildRequires: libArcus-devel = %version
BuildRequires: libstb-devel

%description
CuraEngine is a powerful, fast and robust engine for processing 3D
models into 3D printing instruction for Ultimaker and other GCode
based 3D printers. It is part of the larger open source project
called "Cura".

The CuraEngine is a C++ console application for 3D printing GCode
generation. It has been made as a better and faster alternative
to the old Skeinforge engine.

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1

# bundled libraries
rm -rf libs

%build
%cmake -DBUILD_SHARED_LIBS:BOOL=OFF \
       -DCURA_ENGINE_VERSION:STRING=%version \
       -DUSE_SYSTEM_LIBS:BOOL=ON \
       -DCMAKE_CXX_FLAGS_RELEASE_INIT:STRING="%optflags -fPIC" \
       -DStb_INCLUDE_DIRS:PATH=%_includedir/stb

%cmake_build

%install
%cmakeinstall_std

%check
# Smoke test
%buildroot%_bindir/%name help

%files
%_bindir/*
%doc LICENSE README.md

%changelog
