%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk

%def_without libnm_glib

%define _unpackaged_files_terminate_build 1

Name: NetworkManager-openconnect
Version: 1.2.6
Release: alt1
License: %gpl2plus
Group: System/Configuration/Networking
Summary: NetworkManager VPN integration for openconnect

Url: http://www.gnome.org/projects/NetworkManager/

# https://gitlab.gnome.org/GNOME/NetworkManager-openconnect.git
Source: %name-%version.tar
Patch1: %name-%version-%release.patch
Requires: NetworkManager-daemon >= %nm_version
Requires: openconnect

BuildRequires(pre): rpm-build-licenses
BuildRequires: libopenconnect-devel >= 3.02
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: gcr-libs-devel >= 3.4
BuildRequires: libsecret-devel >= 0.18
BuildRequires: intltool gettext
BuildRequires: libxml2-devel

%description
This package contains software for integrating the openconnect VPN software
with NetworkManager and the GNOME desktop

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %version
Requires: NetworkManager-openconnect = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
    --disable-static \
    --libexecdir=%_libexecdir/NetworkManager \
    --localstatedir=%_var \
%if_without libnm_glib
	--without-libnm-glib \
%endif
    --enable-more-warnings=error

%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS ChangeLog COPYING
%config %_sysconfdir/dbus-1/system.d/nm-openconnect-service.conf
%_libexecdir/NetworkManager/nm-openconnect-service
%_libexecdir/NetworkManager/nm-openconnect-service-openconnect-helper
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-openconnect-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-openconnect-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-openconnect-properties.so
%endif
%_libexecdir/NetworkManager/nm-openconnect-auth-dialog
%_datadir/gnome-vpn-properties/openconnect
%_libdir/NetworkManager/libnm-vpn-plugin-openconnect.so
%_libdir/NetworkManager/libnm-vpn-plugin-openconnect-editor.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/lib*.la

%changelog
