%define nm_version 1.1.90
%define git_date %nil
#define git_date .git20110314
%define ppp_version %((%{__awk} '/^#define VERSION/ { print $NF }' /usr/include/pppd/patchlevel.h 2>/dev/null||echo none)|/usr/bin/tr -d '"')

%def_without gtk4

%define _unpackaged_files_terminate_build 1

%ifarch %e2k
%define more_warnings no
%else
%define more_warnings error
%endif

Name: NetworkManager-pptp
Version: 1.2.10
Release: alt1.p10.1%git_date
License: GPLv2+
Group: System/Configuration/Networking
Summary:  NetworkManager VPN plugin for pptp
Url: https://networkmanager.dev/docs/vpn/
Vcs: https://gitlab.gnome.org/GNOME/NetworkManager-pptp.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: ppp-devel
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel
BuildRequires: libgtk+3-devel
%{?_with_gtk4:BuildRequires: libgtk4-devel >= 4.6.3 libnma-gtk4-devel}
BuildRequires: libsecret-devel
BuildRequires: intltool gettext

Requires: NetworkManager-daemon   >= %nm_version
Requires: NetworkManager-ppp   >= %nm_version
Requires: pptp-client
Requires: ppp = %ppp_version

%description
This package contains software for integrating the pptp VPN software
with NetworkManager.

%package gtk-common
License: GPLv2+
Summary: Common part of %name GTK support
Group: Graphical desktop/GNOME
Requires: NetworkManager-pptp = %version-%release

%description gtk-common
This package contains common part for %name GTK support.

%package gtk3
License: GPLv2+
Summary: Files for GTK3 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

Obsoletes: %name-gtk < 1.2.10-alt1
Provides: %name-gtk = %version-%release

%description gtk3
This package contains files for GTK3 applications to use %name.

%if_with gtk4
%package gtk4
License: GPLv2+
Summary: Files for GTK4 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

%description gtk4
This package contains files for GTK4 applications to use %name.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
	--without-libnm-glib \
	%{subst_with gtk4} \
	--enable-more-warnings=%more_warnings
%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS
%_libexecdir/NetworkManager/nm-pptp-service
%_libdir/NetworkManager/libnm-vpn-plugin-pptp.so
%_libdir/pppd/%ppp_version/*.so
%config %_datadir/dbus-1/system.d/nm-pptp-service.conf
%config %_libexecdir/NetworkManager/VPN/nm-pptp-service.name

%files gtk-common -f %name.lang
%_libexecdir/NetworkManager/nm-pptp-auth-dialog
%_datadir/metainfo/*.xml

%files gtk3
%_libdir/NetworkManager/libnm-vpn-plugin-pptp-editor.so

%if_with gtk4
%files gtk4
%_libdir/NetworkManager/libnm-gtk4-vpn-plugin-pptp-editor.so
%endif

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
