%define lib_name libalkimia5

%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

Name:    alkimia
Version: 8.1.2
Release: alt3

Summary: Alkimia is the infrastructure for common storage and business logic that will be used by all financial applications in KDE
License: LGPLv2+
Group:	 Office
URL:     http://community.kde.org/Alkimia/libalkimia
# Download from https://download.kde.org/stable/alkimia/

Source: %name-%version.tar

BuildRequires(pre): rpm-build-kf5
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: qt5-base-devel
BuildRequires: extra-cmake-modules qt5-tools-devel-static
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: libgmp_cxx-devel
BuildRequires: qt5-declarative-devel
BuildRequires: kf5-kconfig-devel
BuildRequires: kf5-kcoreaddons-devel
BuildRequires: kf5-kdelibs4support-devel
BuildRequires: kf5-knewstuff-devel
BuildRequires: kf5-kpackage-devel
BuildRequires: kf5-plasma-framework-devel
BuildRequires: kf5-kio-devel
BuildRequires: kf5-kxmlgui-devel
BuildRequires: mpir-devel
BuildRequires: doxygen

Requires: lib%name = %version-%release

%description
Alkimia is the infrastructure for common storage and business logic that
will be used by all financial applications in KDE. The target is to
share financial related information over application bounderies.

%package -n lib%name
Summary: A library with common classes and functionality used by finance applications for the KDE SC
Group:   System/Libraries

%description -n lib%name
libalkimia is a library with common classes and functionality used by
finance applications for the KDE SC. Currently it supports a common
class to represent monetary values with arbitrary precision.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/KDE and QT
Requires: lib%name = %version-%release
Requires: mpir-devel

%description -n lib%name-devel
Headers and other files for develop with %name.

%prep
%setup -q

%build
%K5init no_altplace
%K5build -DCMAKE_SKIP_RPATH=1 \
         -DBUILD_WITH_WEBKIT=OFF \
%if_enabled qtwebengine
         -DBUILD_WITH_WEBENGINE=ON \
%else
         -DBUILD_WITH_WEBENGINE=OFF \
%endif
         -DAPPDATA_INSTALL_DIR=%_datadir

%install
%K5install
%K5install_move data knsrcfiles
%find_lang alkimia --all

%files -f alkimia.lang
%doc README.md
%_K5bin/onlinequoteseditor*
%_K5qml/org/kde/alkimia
%_K5xdgapp/*.desktop
%_K5icon/hicolor/*/apps/onlinequoteseditor*
%_datadir/metainfo/*.appdata.xml
%_datadir/kf5/plasma/plasmoids/org.wincak.foreigncurrencies2
%_K5data/knsrcfiles/*.knsrc
%_K5srv/*.desktop

%files -n lib%name
%_libdir/%lib_name.so.*

%files -n lib%name-devel
%dir %_includedir/alkimia
%_includedir/alkimia/*
%_K5link/%lib_name.so
%_pkgconfigdir/%lib_name.pc
%_libdir/cmake/LibAlkimia*

%changelog
