%define _unpackaged_files_terminate_build 1

%def_without guile20
%define _altdata_dir %_datadir/alterator

Name: alterator-fbi
Version: 5.49.4
Release: alt1

Source: %name-%version.tar
Patch0: alterator-fbi-5.49.1-call-cc-via-reset.patch
Patch1: alterator-fbi-5.49.1-call-ec-for-escapes.patch

Summary: alterator on rails
License: GPL
Group: System/Configuration/Other

#backward compatibility
Provides: alterator-http = %version, ahttpd = %version, httpd-alterator = %version, alterator-ahttpd = %version
Obsoletes: alterator-http, ahttpd, httpd-alterator, alterator-ahttpd

Requires: alterator-sh-functions >= 0.13-alt2
Requires: avahi-sh-functions >= 0.1-alt2
Requires: design-alterator
Requires: alterator >= 5.4.1-alt3
Requires: alterator-l10n >= 2.7-alt4
Requires: alterator-sslkey
Requires: gettext
Requires: alterator-l10n >= 2.9.50
Requires: /etc/cron.d

Requires(pre): libguile-vhttpd >= 0.7.11
Requires(pre): shadow-utils

BuildPreReq: alterator >= 5.4.1-alt3, libguile-vhttpd, libexpat-devel

%if_with guile20
BuildRequires: guile20-devel libguile20-devel
%else
BuildPreReq: guile22-devel
%endif

Provides: alterator-etcgit-bar

%description
this is an alterator based engine (form based interface) to create a simple form based html interface

%brp_strip_none %_alterator_libdir/*
%add_verify_elf_skiplist %_alterator_libdir/*

%ifarch %e2k
%def_with delimited_continuations
%else
%def_without delimited_continuations
%endif

%prep
%setup

%if_with delimited_continuations
%patch0 -p2
%patch1 -p2
%endif

%build
%make_build
# broken for now, revisit later
#make check-api

%install
export GUILE_AUTO_COMPILE=0
export LD_LIBRARY_PATH=$(pwd)/src/libguile-xmltokenizer/
mkdir -p %buildroot/%_localstatedir/alterator/csrf-tokens
%makeinstall HTMLROOT=%buildroot%_var/www/ unitdir=%buildroot%_unitdir

#ahttpd
%__install -d %buildroot%_var/run/ahttpd
%__install -d %buildroot%_logdir/ahttpd
%__install -Dpm640 ahttpd.logrotate %buildroot/%_sysconfdir/logrotate.d/ahttpd
%__install -Dpm644 ahttpd.conf %buildroot%_sysconfdir/ahttpd/ahttpd.conf
%__install -Dpm644 acl.conf %buildroot%_sysconfdir/ahttpd/acl.conf
%__install -Dpm644 openssl.cnf %buildroot%_sysconfdir/ahttpd/openssl.cnf
%__install -Dpm755 ahttpd.init %buildroot/%_initrddir/ahttpd
%__install -d %buildroot/%_cachedir/ahttpd
%__install -d %buildroot/

#ssl
touch %buildroot%_sysconfdir/ahttpd/ahttpd.cnf
mkdir -p %buildroot/%_localstatedir/ssl/certs/
touch %buildroot/%_localstatedir/ssl/certs/ahttpd.csr

#compatibility:begin
touch %buildroot/%_datadir/alterator/build/html-messages.mak
#compatibility:end

%pre
/usr/sbin/groupadd -r -f _ahttpd
/usr/sbin/groupadd -r -f _alteratord
/usr/sbin/useradd -r -g _ahttpd -G _alteratord -d /dev/null -s /dev/null -n _ahttpd >/dev/null 2>&1 ||:

%post
%post_service ahttpd

%preun
%preun_service ahttpd

%triggerin -- httpd-alterator
if /sbin/service httpd-alterator status >/dev/null 2>/dev/null; then
    /sbin/service httpd-alterator stop
    /sbin/service ahttpd start
fi ||:
/sbin/service configd stop
/sbin/chkconfig configd --del
/usr/sbin/usermod  -G _alteratord _ahttpd >/dev/null 2>&1 ||:

%triggerin -- ahttpd
/sbin/service configd stop
/sbin/chkconfig configd --del
/usr/sbin/usermod  -G _alteratord _ahttpd >/dev/null 2>&1 ||:

%triggerpostun -- ahttpd
/sbin/chkconfig ahttpd --add
/sbin/chkconfig ahttpd on
/sbin/service ahttpd start


%files
#common
%_bindir/*
%_libdir/guile/*.*/extensions/*.so
%_alterator_libdir/interfaces/guile/*
%_alterator_libdir/type/*
%_alterator_libdir/ui/*
%_libexecdir/alterator/backend3/*
%_datadir/alterator/build/*
%_datadir/alterator/design/images/*
%_datadir/alterator/design/scripts/*
%_datadir/alterator/design/styles/*
%_datadir/alterator/ui/*
%_datadir/alterator/type/*
%_datadir/alterator/interfaces/*/*
%_datadir/alterator/applications/*
%dir %_localstatedir/alterator/csrf-tokens

#server
%config(noreplace) %_sysconfdir/logrotate.d/*
%_initdir/*
%_sbindir/*
%_man5dir/*
%_man8dir/*
%_var/run/ahttpd
%attr(750,root,adm) %_logdir/ahttpd
%attr(700,_ahttpd,root) %dir %_sysconfdir/ahttpd
%config(noreplace) %_sysconfdir/ahttpd/ahttpd.conf
%config(noreplace) %_sysconfdir/ahttpd/acl.conf
%config(noreplace) %_sysconfdir/ahttpd/openssl.cnf
%attr(750,_ahttpd,root) %_cachedir/ahttpd
%_unitdir/ahttpd.service
%_unitdir/ahttpd.socket

#ssl
%ghost  %config(noreplace) %_sysconfdir/ahttpd/ahttpd.cnf
%ghost  %_localstatedir/ssl/certs/ahttpd.csr


%changelog
