%define alterator_libexecdir %_prefix/libexec/alterator

Name: alterator-manager
Version: 0.1.22
Release: alt1

Summary: Modular tool for system configuration via D-Bus
License: GPL-2
Group: System/Configuration/Other

BuildRequires: cmake gcc
BuildRequires: libgio-devel libsystemd-devel libpolkit-devel

Source: %name-%version.tar

%description
Modular tool for system configuration via D-Bus.

%package tools
Summary: Auxiliary tools for the alterator-manager.
Group: Development/Other

%description tools
Auxiliary tools for the alterator-manager.

%package devel
Summary: Headers for developing alterator-manager modules
Group: Development/Other
Requires: libgio-devel

%description devel
Headers for developing alterator-manager modules.


%prep
%setup -q

%build
%cmake -DCMAKE_BUILD_TYPE=Release
%cmake_build

%install
%cmakeinstall_std
mkdir -p %buildroot%alterator_libexecdir
mkdir -p %buildroot%_datadir/alterator/backends
mkdir -p %buildroot%_datadir/alterator/backends/user
mkdir -p %buildroot%_datadir/alterator/backends/system
mkdir -p %buildroot%_sysconfdir/alterator/backends
mkdir -p %buildroot%_sysconfdir/alterator/backends/user
mkdir -p %buildroot%_sysconfdir/alterator/backends/system
mkdir -p %buildroot%_datadir/polkit-1/actions
mkdir -p %buildroot%_rpmlibdir/
mv -f %buildroot%_prefix/lib/systemd/user/alterator-manager.service-user \
      %buildroot%_prefix/lib/systemd/user/alterator-manager.service
mv -f %buildroot%_datadir/dbus-1/services/ru.basealt.alterator-manager.service-user \
      %buildroot%_datadir/dbus-1/services/ru.basealt.alterator-manager.service

%files
%_sbindir/%name
%_datadir/dbus-1/system.d/ru.basealt.alterator-manager.conf
%_datadir/dbus-1/services/ru.basealt.alterator-manager.service
%_datadir/dbus-1/system-services/ru.basealt.alterator-manager.service
%_unitdir/alterator-manager.service
%_prefix/lib/systemd/user/alterator-manager.service
%_datadir/polkit-1/actions/ru.basealt.alterator.manager.policy
%_rpmlibdir/%name.filetrigger
%dir %alterator_libexecdir
%dir %_datadir/alterator/backends
%dir %_datadir/alterator/backends/user
%dir %_datadir/alterator/backends/system
%dir %_sysconfdir/alterator/backends
%dir %_sysconfdir/alterator/backends/user
%dir %_sysconfdir/alterator/backends/system
%doc docs/*

%files devel
%_includedir/alterator

%files tools
%_bindir/am-dev-tool


%changelog
